/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CSaveOptDlg - 保存設定ダイアログ
*/


#include "CSaveOptDlg.h"

#include "CConfig.h"
#include "CMainWin.h"
#include "CImageRGB16.h"

#include "AXImage.h"
#include "AXLayout.h"
#include "AXLabel.h"
#include "AXLineEdit.h"
#include "AXCheckButton.h"
#include "AXColorButton.h"
#include "AXComboBox.h"
#include "AXScrollView.h"
#include "AXScrollArea.h"
#include "AXScrollBar.h"
#include "AXApp.h"

#include "draw_main.h"

#include "drawdat.h"
#include "global.h"
#include "strid.h"


//----------------------

enum
{
    WID_BT_TPCOL = 100
};

enum
{
    STRID_TITLE,
    STRID_TPCOL,
    STRID_PNG_LEVEL,
    STRID_JPEG_QUALITY,
    STRID_JPEG_SAMP,
    STRID_GIF_HELP,
    STRID_GETTP_TITLE,
};

//----------------------

class CSaveOpt_gettp_area:public AXScrollArea
{
    AXImage     m_img;
    DRAWCANVASINFO  m_dinfo;
    CANVASVIEWPARAM m_vparam;

public:
    CSaveOpt_gettp_area(AXWindow *pParent);

    void draw();

    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onSize();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

class CSaveOpt_gettp_dlg:public AXDialog
{
    AXScrollView    *m_pview;

public:
    CSaveOpt_gettp_dlg(AXWindow *pOwner);

    virtual BOOL onClose();
    virtual BOOL onSize();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//----------------------


//**********************************
// CSaveOptDlg
//**********************************


CSaveOptDlg::CSaveOptDlg(AXWindow *pOwner,int format,int *pTPCol)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*pl;
    int i;

    m_nFormat = format;
    m_pTPCol  = pTPCol;

    //

    _trgroup(strid::GROUP_DLG_SAVEOPT);

    setTitle(STRID_TITLE);

    setLayout(plTop = new AXLayoutVert);
    plTop->setSpacing(10);

    //

    switch(format)
    {
        //PNG
        case CMainWin::FILEFORMAT_PNG:
            //圧縮率

            plTop->addItem(pl = new AXLayoutHorz(0, 7));
            pl->setPaddingBottom(8);

            pl->addItem(new AXLabel(this, 0, LF_CENTER_Y, 0, STRID_PNG_LEVEL));
            pl->addItem(m_pedit[0] = new AXLineEdit(this, AXLineEdit::ES_SPIN, LF_CENTER_Y));

            m_pedit[0]->setInit(3, 0, 9, g_conf->btPNGLevel);

            //透過色

            _addWid_tpCol();
            break;
        //JPEG
        case CMainWin::FILEFORMAT_JPEG:
            plTop->addItem(pl = new AXLayoutMatrix(2));

            //品質

            pl->addItem(new AXLabel(this, 0, LF_CENTER_Y, MAKE_DW4(0,0,6,8), STRID_JPEG_QUALITY));
            pl->addItem(m_pedit[0] = new AXLineEdit(this, AXLineEdit::ES_SPIN, LF_CENTER_Y, 0, MAKE_DW4(0,0,0,8)));

            m_pedit[0]->setInit(5, 1, 100, g_conf->uJPEGSave & 127);

            //サンプリング比

            pl->addItem(new AXLabel(this, 0, LF_CENTER_Y, MAKE_DW4(0,0,6,0), STRID_JPEG_SAMP));
            pl->addItem(m_pcombo = new AXComboBox(this, 0, 0));

            m_pcombo->addItem("4:4:4 (Hi)", 444);
            m_pcombo->addItem("4:2:2", 422);
            m_pcombo->addItem("4:1:1 (Low)", 411);

            m_pcombo->setAutoWidth();

            for(i = 0; i < 3; i++)
            {
                if(m_pcombo->getItemParam(i) == ((g_conf->uJPEGSave >> 7) & 511))
                    m_pcombo->setCurSel(i);
            }
            break;
        //GIF
        case CMainWin::FILEFORMAT_GIF:
            _addWid_tpCol();

            plTop->addItem(new AXLabel(this, 0, 0, MAKE_DW4(0,10,0,0), STRID_GIF_HELP));
            break;
    }

    //

    createOKCancelAndShow();
}

//! 透過色ウィジェット追加

void CSaveOptDlg::_addWid_tpCol()
{
    AXLayout *pl;
    RGBFIX15 col;
    DWORD dwCol;

    getLayout()->addItem(pl = new AXLayoutHorz(0, 6));

    pl->addItem(m_pckTpCol = new AXCheckButton(this, 0, LF_CENTER_Y, 0, 0, STRID_TPCOL, (g_draw->nSaveTPCol != -1)));
    pl->addItem(m_pbtTpCol = new AXColorButton(this, 0, LF_CENTER_Y, WID_BT_TPCOL, 0));

    //色

    if(g_draw->nSaveTPCol == -1)
    {
        draw::getPixelBlendColor(&col, 0, 0);
        dwCol = col.toDWORD();
    }
    else
        dwCol = g_draw->nSaveTPCol;

    m_pbtTpCol->setColor(dwCol);
}

//! 通知

BOOL CSaveOptDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    switch(pwin->getItemID())
    {
        //透過色ボタン
        case WID_BT_TPCOL:
            {
            CSaveOpt_gettp_dlg *pdlg = new CSaveOpt_gettp_dlg(this);
            int ret;

            ret = pdlg->runDialog();

            if(ret != -1) m_pbtTpCol->setColor(ret);
            }
            break;

        //OK
        case 1:
            _endOK();
            endDialog(TRUE);
            break;
        //cancel
        case 2:
            endDialog(FALSE);
            break;
    }

    return TRUE;
}

//! 値を取得

void CSaveOptDlg::_endOK()
{
    switch(m_nFormat)
    {
        //PNG
        case CMainWin::FILEFORMAT_PNG:
            g_conf->btPNGLevel = m_pedit[0]->getVal();
            break;
        //JPEG
        case CMainWin::FILEFORMAT_JPEG:
            g_conf->uJPEGSave = m_pedit[0]->getVal();
            g_conf->uJPEGSave |= (m_pcombo->getItemParam(-1) << 7);
            break;
    }

    //透過色

    *m_pTPCol = -1;

    if(m_nFormat == CMainWin::FILEFORMAT_PNG || m_nFormat == CMainWin::FILEFORMAT_GIF)
    {
        if(m_pckTpCol->isChecked())
            *m_pTPCol = m_pbtTpCol->getColor();
    }
}


//*****************************************
// CSaveOpt_gettp_dlg - 透過色取得ダイアログ
//*****************************************


CSaveOpt_gettp_dlg::CSaveOpt_gettp_dlg(AXWindow *pOwner)
    : AXDialog(pOwner, WS_DIALOG_NORMAL)
{
    AXScrollArea *parea;

    setTitle(STRID_GETTP_TITLE);

    //

    m_pview = new AXScrollView(this, AXScrollView::SVS_HORZVERT_FIX, 0);
    m_pview->setScrollArea(parea = new CSaveOpt_gettp_area(m_pview));

    m_pview->calcDefSize();

    parea->setNotify(this);

    //

    resize(400, 400);
    show();
}

//! 閉じる

BOOL CSaveOpt_gettp_dlg::onClose()
{
    endDialog(-1);
    return TRUE;
}

//! サイズ変更

BOOL CSaveOpt_gettp_dlg::onSize()
{
    m_pview->resize(m_nW, m_nH);

    return TRUE;
}

//! 通知

BOOL CSaveOpt_gettp_dlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    if(pwin == m_pview && uNotify == 5000)
        endDialog((int)lParam);

    return TRUE;
}


//*****************************************
// CSaveOpt_gettp_area - 表示エリア
//*****************************************


CSaveOpt_gettp_area::CSaveOpt_gettp_area(AXWindow *pParent)
    : AXScrollArea(pParent, 0)
{
    m_vparam.dScaleDiv = 1.0 / 8;

    m_dinfo.nBaseX  = 0;
    m_dinfo.nBaseY  = 0;
    m_dinfo.dwExCol = 0x808080;
    m_dinfo.bHRev   = FALSE;
    m_dinfo.pParam  = &m_vparam;
}

//! サイズ変更

BOOL CSaveOpt_gettp_area::onSize()
{
    m_img.recreate(m_nW, m_nH, 32, 32);

    scrH()->setStatus(0, g_draw->nImgW << 3, m_nW);
    scrV()->setStatus(0, g_draw->nImgH << 3, m_nH);

    draw();

    return TRUE;
}

//! 描画

BOOL CSaveOpt_gettp_area::onPaint(AXHD_PAINT *phd)
{
    m_img.put(m_id);

    return TRUE;
}

//! 通知

BOOL CSaveOpt_gettp_area::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    if(uNotify == SAN_SCROLL_HORZ || uNotify == SAN_SCROLL_VERT)
        draw();

    return TRUE;
}

//! ボタン押し

BOOL CSaveOpt_gettp_area::onButtonDown(AXHD_MOUSE *phd)
{
    RGBFIX15 col;
    int x,y;

    if(phd->button == BUTTON_LEFT)
    {
        x = (phd->x + scrH()->getPos()) >> 3;
        y = (phd->y + scrV()->getPos()) >> 3;

        if(draw::getPixelBlendColor(&col, x, y))
            m_pNotify->onNotify(m_pParent, 5000, col.toDWORD());
    }

    return TRUE;
}

//! イメージ描画

void CSaveOpt_gettp_area::draw()
{
    m_dinfo.rcsDst.set(0, 0, m_nW, m_nH);

    m_dinfo.nScrollX = -scrH()->getPos();
    m_dinfo.nScrollY = -scrV()->getPos();

    g_draw->pimgBlend->drawCanvasNormal(&m_img, m_dinfo);

    redraw();
}
