/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CKeyOptDlg - キー設定ダイアログ
*/


#include "CKeyOptDlg.h"

#include "CCmdListTreeView.h"

#include "AXLayout.h"
#include "AXLabel.h"
#include "AXButton.h"
#include "AXMessageBox.h"
#include "AXApp.h"
#include "AXTrSysID.h"

#include "strid.h"


//------------------------

#define WID_BTT_ALLCLEAR    100

enum
{
    STRID_TITLE,
    STRID_CLEARALL,
    STRID_HELP
};

//------------------------


CKeyOptDlg::CKeyOptDlg(AXWindow *pOwner)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*pl;
    AXWindow *pwin;

    _trgroup(strid::GROUP_DLG_KEYOPT);

    setTitle(STRID_TITLE);

    setLayout(plTop = new AXLayoutHorz(0, 8));
    plTop->setSpacing(10);

    //ツリー

    plTop->addItem(m_pTree = new CCmdListTreeView(this, CCmdListTreeView::STYLE_KEY, LF_EXPAND_WH, 0, 0));

    //ヘルプ+ボタン

    plTop->addItem(pl = new AXLayoutVert(LF_EXPAND_H, 4));

    pl->addItem(new AXLabel(this, AXLabel::LS_SUNKEN, LF_EXPAND_Y, 0, STRID_HELP));

    pl->addItem(new AXButton(this, 0, LF_EXPAND_W, WID_BTT_ALLCLEAR, MAKE_DW4(0,0,0,15), STRID_CLEARALL));

    pl->addItem(pwin = new AXButton(this, 0, LF_EXPAND_W, 1, 0, TRSYS_GROUPID, TRSYS_OK));
    pl->addItem(new AXButton(this, 0, LF_EXPAND_W, 2, 0, TRSYS_GROUPID, TRSYS_CANCEL));

    setDefaultButton(pwin);

    //

    m_pTree->setCmdList();

    //

    calcDefSize();
    resize((m_nDefW < 500)? 500: m_nDefW, (m_nDefH < 400)? 400: m_nDefH);

    show();
}

//! 通知

BOOL CKeyOptDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    switch(pwin->getItemID())
    {
        //全てクリア
        case WID_BTT_ALLCLEAR:
            if(AXMessageBox::message(this, NULL, _string(strid::GROUP_MESSAGE, strid::MES_CLEARALL),
                                     AXMessageBox::YES | AXMessageBox::NO,
                                     AXMessageBox::YES) == AXMessageBox::YES)
                m_pTree->clearAll();
            break;

        //OK
        case 1:
            m_pTree->setKeyDat();

            endDialog(1);
            break;
        //キャンセル
        case 2:
            endDialog(0);
            break;
    }

    return TRUE;
}
