/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#include "struct.h"


//=============================
// RGBFIX15
//=============================


//! 32bit値から色セット

void RGBFIX15::set(DWORD col)
{
    r = ((_GETR(col) << 15) + 127) / 255;
    g = ((_GETG(col) << 15) + 127) / 255;
    b = ((_GETB(col) << 15) + 127) / 255;
}

//! DWORD値に変換

DWORD RGBFIX15::toDWORD()
{
    int rr,gg,bb;

    rr = (r * 255 + 0x4000) >> 15;
    gg = (g * 255 + 0x4000) >> 15;
    bb = (b * 255 + 0x4000) >> 15;

    return (rr << 16) | (gg << 8) | bb;
}


//=============================
// RGBAFIX15
//=============================


//! 32bit値から色セット

void RGBAFIX15::set(DWORD col)
{
    r = ((_GETR(col) << 15) + 127) / 255;
    g = ((_GETG(col) << 15) + 127) / 255;
    b = ((_GETB(col) << 15) + 127) / 255;
    a = (((col >> 24) << 15) + 127) / 255;
}

//! DWORD値に変換

DWORD RGBAFIX15::toDWORD()
{
    DWORD rr,gg,bb,aa;

    rr = (r * 255 + 0x4000) >> 15;
    gg = (g * 255 + 0x4000) >> 15;
    bb = (b * 255 + 0x4000) >> 15;
    aa = (a * 255 + 0x4000) >> 15;

    return (aa << 24) | (rr << 16) | (gg << 8) | bb;
}


//=============================
// DRAWCANVASINFO
//=============================


//! イメージ位置->キャンバス位置

void DRAWCANVASINFO::imgTocanv(double *pX,double *pY,double x,double y) const
{
    x = (x - nBaseX) * pParam->dScale; if(bHRev) x = -x;
    y = (y - nBaseY) * pParam->dScale;

    *pX = (x * pParam->dCos - y * pParam->dSin) + nScrollX;
    *pY = (x * pParam->dSin + y * pParam->dCos) + nScrollY;
}

//! イメージ位置->キャンバス位置 の1px移動の差分取得
/*
    [0] x-x [1] x-y [2] y-x [3] y-y
*/

void DRAWCANVASINFO::getImgToCanvDiff(double *pdst) const
{
    pdst[0] = pParam->dScale * pParam->dCos;
    pdst[1] = pParam->dScale * pParam->dSin;
    pdst[2] = -pdst[1];
    pdst[3] = pdst[0];

    if(bHRev)
        pdst[0] = -pdst[0], pdst[1] = -pdst[1];
}


//=============================
// FLAGRECT
//=============================


//! AXRectSize からセット

void FLAGRECT::set(const AXRectSize &rcs)
{
    x1 = rcs.x, y1 = rcs.y;
    x2 = rcs.x + rcs.w - 1;
    y2 = rcs.y + rcs.h - 1;
    flag = TRUE;
}

//! 点を含める

void FLAGRECT::incPoint(int x,int y)
{
    if(flag)
    {
        if(x < x1) x1 = x;
        if(y < y1) y1 = y;
        if(x > x2) x2 = x;
        if(y > y2) y2 = y;
    }
    else
    {
        x1 = x2 = x;
        y1 = y2 = y;
        flag = TRUE;
    }
}

//! 範囲を結合

void FLAGRECT::combine(const FLAGRECT &src)
{
    if(!flag)
        //空の状態ならそのままコピー
        *this = src;
    else if(src.flag)
    {
        if(src.x1 < x1) x1 = src.x1;
        if(src.y1 < y1) y1 = src.y1;
        if(src.x2 > x2) x2 = src.x2;
        if(src.y2 > y2) y2 = src.y2;
    }
}

//! 指定数移動

void FLAGRECT::move(int mx,int my)
{
    if(flag)
    {
        x1 += mx, x2 += mx;
        y1 += my, y2 += my;
    }
}

//! src と、src を pt 分移動した範囲を結合

void FLAGRECT::combineMove(const FLAGRECT &src,int mx,int my)
{
    *this = src;
    move(mx, my);

    combine(src);
}

//! 範囲拡張

void FLAGRECT::inflate(int n)
{
    if(flag)
    {
        x1 -= n, x2 += n;
        y1 -= n, y2 += n;
    }
}


//=============================
// RECTANDSIZE
//=============================


//! AXRect からセット

void RECTANDSIZE::set(const AXRect &rc)
{
    x1 = rc.left,  y1 = rc.top;
    x2 = rc.right, y2 = rc.bottom;
    w = x2 - x1 + 1;
    h = y2 - y1 + 1;
}

//! FLAGRECT からセット

void RECTANDSIZE::set(const FLAGRECT &rcf)
{
    x1 = rcf.x1, y1 = rcf.y1;
    x2 = rcf.x2, y2 = rcf.y2;
    w = x2 - x1 + 1;
    h = y2 - y1 + 1;
}

//! 範囲拡張

void RECTANDSIZE::inflate(int n)
{
    x1 -= n; y1 -= n;
    x2 += n; y2 += n;
    w += n * 2; h += n * 2;
}
