/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    文字列ID
*/


#ifndef _AZPT_STRID_H_
#define _AZPT_STRID_H_

namespace strid
{

/* グループ */

enum GROUPID
{
    GROUP_MAINMENU = 0,
    GROUP_IMGVIEWMENU,
    GROUP_PREVWINMENU,
    GROUP_COLORWIN,
    GROUP_OPTIONWIN,
    GROUP_LAYER,
    GROUP_LAYERRMENU,
    GROUP_GRADCUSTOMMENU,
    GROUP_BRUSHSIZELIST,
    GROUP_BRUSHLIST,
    GROUP_BRUSHITEM,
    GROUP_CMDLIST,

    GROUP_TOOL = 100,
    GROUP_DRAWTYPE,
    GROUP_BLENDNAME,
    GROUP_TEXBRUSHIMG,
    GROUP_PIXTYPE,
    GROUP_STATUS_HELP,
    GROUP_SCALETYPE,

    GROUP_DLG_NEW = 500,
    GROUP_DLG_GRIDOPT,
    GROUP_DLG_RESIZECANVAS,
    GROUP_DLG_CHANGEDPI,
    GROUP_DLG_DRAWTEXT,
    GROUP_DLG_GRADEDIT,
    GROUP_DLG_SCALECANVAS,
    GROUP_DLG_KEYOPT,
    GROUP_DLG_DEVICEOPT,
    GROUP_DLG_SCALEROT,
    GROUP_DLG_SAVEOPT,
    GROUP_DLG_TRIMMING,
    GROUP_DLG_ENVOPT,
    GROUP_DLG_FILTER,

    GROUP_TOOLTIP_MAIN = 1000,
    GROUP_TOOLTIP_LAYER,
    GROUP_BOXEDIT,

    GROUP_WORD = 2000,
    GROUP_MESSAGE
};

/* 共通単語 */

enum WORD
{
    WORD_WIDTH,
    WORD_HEIGHT,
    WORD_COLOR,
    WORD_OPACITY,
    WORD_NAME,
    WORD_SIZE,
    WORD_DENSITY,
    WORD_BLENDMODE,
    WORD_COLORTYPE,
    WORD_PIXTYPE,
    WORD_ANTIALIAS
};

/* メッセージ */

enum MESSAGE
{
    MES_FAILED_LOAD,
    MES_LOADERR_IMGSIZE,
    MES_LOADERR_OPENFILE,
    MES_LOADERR_FORMAT,
    MES_FAILED,
    MES_FAILED_SAVE,
    MES_SAVE_CHANGEIMAGE,
    MES_KEY_SAMEKEY,
    MES_CLEARALL,
    MES_DEV_DELETE,
    MES_DEV_CLEAR,
    MES_SAVE_NOAPD,
    MES_SAVE_OVERWRITE,
    MES_SAVE_GIF_OVER,
    MES_LAYER_FOLDER,
    MES_LAYER_LOCK,
    MES_FILTER_COLOROP,
    MES_FILTER_NONEOPTTEX,
    MES_FILTER_NONEGRAD
};

/* テクスチャ・ブラシ画像 */

enum
{
    TEXBRUSH_DLG_TITLE,

    TEXBRUSH_NONE,
    TEXBRUSH_OPTTEXTURE,
    TEXBRUSH_NONE_FORCE,
    TEXBRUSH_CIRCLE,

    TEXBRUSH_MENU_SELIMG = 100,
    TEXBRUSH_MENU_NONE,
    TEXBRUSH_MENU_OPTTEXTURE,
    TEXBRUSH_MENU_NONE_FORCE,
    TEXBRUSH_MENU_CIRCLE
};

/* メインメニュー */

enum MAINMENU
{
    MENU_TOP_FILE = 1,
    MENU_TOP_EDIT,
    MENU_TOP_SEL,
    MENU_TOP_LAYER,
    MENU_TOP_FILTER,
    MENU_TOP_VIEW,
    MENU_TOP_OPTION,
    MENU_TOP_HELP,

    //ファイル
    MENU_FILE_NEW = 10000,
    MENU_FILE_OPEN,
    MENU_FILE_SAVE,
    MENU_FILE_SAVERE,
    MENU_FILE_SUB_EXPORT,
    MENU_FILE_SUB_RECENTFILE,
    MENU_FILE_EXIT,

    MENU_FILE_FORMAT_APD = 10050,
    MENU_FILE_FORMAT_PSD,
    MENU_FILE_FORMAT_BMP,
    MENU_FILE_FORMAT_PNG,
    MENU_FILE_FORMAT_JPEG,
    MENU_FILE_FORMAT_GIF,
    MENU_FILE_FORMAT_PSD_NOLAYER_8BITRGB,
    MENU_FILE_FORMAT_PSD_NOLAYER_GRAYSCALE,
    MENU_FILE_FORMAT_PSD_NOLAYER_MONOCHROME,
    MENU_FILE_FORMAT_PNG_ALPHA,

    //編集
    MENU_EDIT_UNDO = 10100,
    MENU_EDIT_REDO,
    MENU_EDIT_PAINT,
    MENU_EDIT_ERASE,
    MENU_EDIT_RESIZECANVAS,
    MENU_EDIT_SCALECANVAS,
    MENU_EDIT_TRIMMING,
    MENU_EDIT_CHANGEDPI,

    //選択
    MENU_SEL_DESELECT = 10200,
    MENU_SEL_INVERSE,
    MENU_SEL_ALL,
    MENU_SEL_COPY,
    MENU_SEL_CUT,
    MENU_SEL_PASTE,
    MENU_SEL_INFLATE,
    MENU_SEL_DEFLATE,

    //レイヤ
    MENU_LAYER_TOPID = 10300,
    MENU_LAYER_ENDID = 10399,
    MENU_LAYER_NEWLAYER = 10300,
    MENU_LAYER_NEWFOLDER,
    MENU_LAYER_FROMIMG,
    MENU_LAYER_COPY,
    MENU_LAYER_DELETE,
    MENU_LAYER_CLEAR,
    MENU_LAYER_IMGDROP,
    MENU_LAYER_COMBINE,
    MENU_LAYER_RENAME,
    MENU_LAYER_CHANGECOLTYPE,
    MENU_LAYER_COMBINESOME,
    MENU_LAYER_UNITE,
    MENU_LAYER_EDIT,
    MENU_LAYER_VIEW,
    MENU_LAYER_CHECK,
    MENU_LAYER_SAVE,
    MENU_LAYER_EDIT_HREV,
    MENU_LAYER_EDIT_VREV,
    MENU_LAYER_EDIT_LROT,
    MENU_LAYER_EDIT_RROT,
    MENU_LAYER_VIEW_ALLSHOW,
    MENU_LAYER_VIEW_ALLHIDE,
    MENU_LAYER_VIEW_ONLYCUR,
    MENU_LAYER_VIEW_TOGGLECHECK,
    MENU_LAYER_CHECK_LINKOFF,
    MENU_LAYER_CHECK_CHECKOFF,
    MENU_LAYER_VIEW_TOGGLE_NORMAL,

    MENU_LAYER_TMP_MOVEUP = 10398,
    MENU_LAYER_TMP_MOVEDOWN,

    //フィルタ

    MENU_FILTER_TOP = 10600,
    MENU_FILTER_END = 10900,

    MENU_FILTER_COLOR_TOP = 10600,
    MENU_FILTER_COLOROP_TOP,
    MENU_FILTER_ALPHA1_TOP,
    MENU_FILTER_ALPHA2_TOP,
    MENU_FILTER_BLUR_TOP,
    MENU_FILTER_DRAW_TOP,
    MENU_FILTER_PIX_TOP,
    MENU_FILTER_EDGE_TOP,
    MENU_FILTER_EFFECT_TOP,
    MENU_FILTER_TRANS_TOP,
    MENU_FILTER_ETC_TOP,
    MENU_FILTER_COMIC_TOP,

    MENU_FILTER_COLOR_BRIGHTCONT = 10620,
    MENU_FILTER_COLOR_GAMMA,
    MENU_FILTER_COLOR_LEVEL,
    MENU_FILTER_COLOR_RGB,
    MENU_FILTER_COLOR_HSV,
    MENU_FILTER_COLOR_NEGA,
    MENU_FILTER_COLOR_GRAYSCALE,
    MENU_FILTER_COLOR_SEPIA,
    MENU_FILTER_COLOR_THRESHOLD,
    MENU_FILTER_COLOR_THRESHOLD_DITHER,
    MENU_FILTER_COLOR_POSTERIZE,
    MENU_FILTER_COLOROP_DRAWCOL_REP,
    MENU_FILTER_BLUR_BLUR,
    MENU_FILTER_BLUR_GAUSS,
    MENU_FILTER_BLUR_MOTION,
    MENU_FILTER_BLUR_RADIAL,
    MENU_FILTER_BLUR_LENS,
    MENU_FILTER_DRAW_FRAME,
    MENU_FILTER_DRAW_LINE,
    MENU_FILTER_DRAW_CHECK,
    MENU_FILTER_DRAW_RANDOMPOINT,
    MENU_FILTER_DRAW_CLOUD,
    MENU_FILTER_DRAW_AMITONE1,
    MENU_FILTER_DRAW_AMITONE2,
    MENU_FILTER_PIX_MOZAIC,
    MENU_FILTER_PIX_CRYSTAL,
    MENU_FILTER_PIX_HALFTONE,
    MENU_FILTER_EDGE_SHARP,
    MENU_FILTER_EDGE_UNSHARPMASK,
    MENU_FILTER_EDGE_SOBEL,
    MENU_FILTER_EDGE_LAPLACIAN,
    MENU_FILTER_EFF_GLOW,
    MENU_FILTER_EFF_RGBSHIFT,
    MENU_FILTER_EFF_OILPAINTING,
    MENU_FILTER_EFF_EMBOSS,
    MENU_FILTER_EFF_NOISE,
    MENU_FILTER_EFF_DIFFUSION,
    MENU_FILTER_EFF_SCRATCH,
    MENU_FILTER_EFF_MEDIAN,
    MENU_FILTER_EFF_BLURRING,
    MENU_FILTER_TRANS_WAVE,
    MENU_FILTER_TRANS_RIPPLE,
    MENU_FILTER_TRANS_POLAR,
    MENU_FILTER_TRANS_RADIALSLIDE,
    MENU_FILTER_TRANS_SWIRL,
    MENU_FILTER_ETC_LUMTOALPHA,
    MENU_FILTER_ETC_1PXDOT_THINNING,
    MENU_FILTER_ETC_ANTIALIASING,
    MENU_FILTER_ETC_HEMMING,
    MENU_FILTER_ETC_3DBUTTON,
    MENU_FILTER_ETC_SHIFT,
    MENU_FILTER_DRAW_EDGE,
    MENU_FILER_EDGE_HIGHPASS,
    MENU_FILTER_COMIC_CONCLINE,
    MENU_FILTER_COMIC_FLASH,
    MENU_FILTER_COMIC_POPUPFLASH,
    MENU_FILTER_COMIC_UNIFLASH,
    MENU_FILTER_COMIC_UNIFLASH_WAVE,
    MENU_FILTER_COLOR_GRADMAP,

    MENU_FILTER_COLOROP_DRAWCOL_TP = 10800,
    MENU_FILTER_COLOROP_DRAWCOLEX_TP,
    MENU_FILTER_COLOROP_DRAWCOL_BACKCOL,
    MENU_FILTER_COLOROP_TP_DRAWCOL,

    MENU_FILTER_ALPHA1_TP_TP = 10810,
    MENU_FILTER_ALPHA1_NONETP_TP,
    MENU_FILTER_ALPHA1_COPY,
    MENU_FILTER_ALPHA1_ADD,
    MENU_FILTER_ALPHA1_SUB,
    MENU_FILTER_ALPHA1_MUL,
    MENU_FILTER_ALPHA1_LUM,
    MENU_FILTER_ALPHA1_LUMREV,

    MENU_FILTER_ALPHA2_LUMREV = 10820,
    MENU_FILTER_ALPHA2_LUM,
    MENU_FILTER_ALPHA2_NONETP,
    MENU_FILTER_ALPHA2_TEXTURE,
    MENU_FILTER_ALPHA2_GRAYSCALE,

    //表示
    MENU_VIEW_TOOLWIN = 10400,
    MENU_VIEW_LAYERWIN,
    MENU_VIEW_BRUSHWIN,
    MENU_VIEW_OPTIONWIN,
    MENU_VIEW_COLORWIN,
    MENU_VIEW_PREVWIN,
    MENU_VIEW_IMGVIEWWIN,
    MENU_VIEW_FILTERLISTWIN,
    MENU_VIEW_ALLHIDE = 10410,
    MENU_VIEW_RESETCANVAS,
    MENU_VIEW_CANVASHREV,
    MENU_VIEW_BKCHECK,
    MENU_VIEW_GRID,
    MENU_VIEW_GRIDSPLIT,
    MENU_VIEW_TOOLBAR,
    MENU_VIEW_SCROLLBAR,

    //設定
    MENU_OPT_ENV = 10500,
    MENU_OPT_DEVICE,
    MENU_OPT_KEY,
    MENU_OPT_GRID,

    //ヘルプ
    MENU_HELP_MANUAL_JA = 10510,
    MENU_HELP_VERSION
};

/* メイン拡張 */

enum MAINEX
{
    MAINEX_SCALEMENU = 10900,
    MAINEX_SCALE_UP,
    MAINEX_SCALE_DOWN,
    MAINEX_ROTATE_LEFT,
    MAINEX_ROTATE_RIGHT,
    MAINEX_EXPORT
};

/* イメージビューウィンドウメニュー */

enum IMGVIEWMENU
{
    IMGV_OPEN = 10000,
    IMGV_NEXT,
    IMGV_PREV,
    IMGV_CLEAR,
    IMGV_SCALEUP,
    IMGV_SCALEDOWN,
    IMGV_FITSIZE,
    IMGV_FULLVIEW
};

/* プレビューウィンドウメニュー */

enum PREVWINMENU
{
    PREVW_LEFTBTT = 0,
    PREVW_RIGHTBTT,
    PREVW_FULLVIEW,
    PREVW_CHANGE_LOUPE,
    PREVW_CHANGE_NORMAL,

    PREVW_BTT_PREVSCR = 100,
    PREVW_BTT_CANVASSCR
};

/* カラーウィンドウ関連 */

enum COLWIN
{
    COLWIN_COLMASK = 0,

    COLWIN_PALCOL_SET = 100,
    COLWIN_PALCOL_INS,
    COLWIN_PALCOL_DEL,

    COLWIN_PALMENU_RESIZE = 1000,
    COLWIN_PALMENU_LOAD,
    COLWIN_PALMENU_SAVE,
    COLWIN_PALMENU_FROMIMG,
    COLWIN_PALMENU_CLEAR,
    COLWIN_PALMENU_DISPLAYSIZE,
    COLWIN_PALMENU_HELP,

    COLWIN_DLG_PALRESIZE_TITLE = 2000,
    COLWIN_DLG_PALRESIZE_MESSAGE,
    COLWIN_MES_PAL_CLEAR,
    COLWIN_MES_PAL_HELP,
    COLWIN_DLG_DISPSIZE_TITLE,
    COLWIN_DLG_DISPSIZE_MESSAGE
};

/* オプションウィンドウ関連 */

enum
{
    OPTWIN_TABNAMETOP = 0,

    OPTWIN_IMGBKCOL = 1000,
    OPTWIN_RULE_ANGLE,
    OPTWIN_RULE_CTPOS,
    OPTWIN_SEL_DISABLE_LINK,
    OPTWIN_JUDGE,
    OPTWIN_PAINT_DIFF,
    OPTWIN_GRAD_DEFAULT,
    OPTWIN_GRAD_CUSTOM,
    OPTWIN_GRAD_REVERSE,
    OPTWIN_GRAD_LOOP,
    OPTWIN_HT_LINE,
    OPTWIN_HT_BEZIER,
    OPTWIN_HT_HEAD,
    OPTWIN_HT_TAIL,
    OPTWIN_HT_REGIST,

    OPTWIN_DOTPEN_TYPE_TOP = 10000,
    OPTWIN_MOVE_TYPE_TOP = 10010,
    OPTWIN_SEL_TYPE_TOP = 10020,
    OPTWIN_PAINT_TYPE_TOP = 10030
};

/* レイヤ関連 */

enum
{
    LAYER_INFO_LOCK,
    LAYER_INFO_AMASK,
    LAYER_RENAME_TITLE,
    LAYER_NEWDLG_TITLE,
    LAYER_NEWFOLDER_TITLE,
    LAYER_FOLDER,
    LAYER_COLTYPEDLG_TITLE,
    LAYER_LUMTOALPHA,
    LAYER_COMBINESOMEDLG_TITLE,
    LAYER_COMBINE_NEWLAYER,
    LAYER_COMBINE_COLTYPE,
    LAYER_COMBINE_HELP,

    LAYER_AMASKMENU_TOP = 1000,
    LAYER_COLTYPE_TOP = 1100,
    LAYER_COMBINESOME_TYPE_TOP = 1200
};

/* レイヤ右クリメニュー */

enum LAYERRMENU
{
    LAYERRMENU_RENAME = 0,
    LAYERRMENU_CHANGECOLTYPE,
    LAYERRMENU_SETCOL,
    LAYERRMENU_LOCK,
    LAYERRMENU_LINK,
    LAYERRMENU_PAINT,
    LAYERRMENU_LAYERMASK,
    LAYERRMENU_LAYERMASKUNDER,
    LAYERRMENU_CHECK
};

/* ブラシ一覧 */

enum
{
    BRUSHLIST_RENAME_TITLE = 0,
    BRUSHLIST_MES_GROUPDEL,

    BRUSHLIST_MENU_GROUP = 1000,
    BRUSHLIST_MENU_BRUSHEX = 1100,
    BRUSHLIST_MENU_BRUSH = 1200
};

//--------------- ダイアログ

/* 新規作成ダイアログ */

enum DLG_NEW
{
    NEWDLG_TITLE,
    NEWDLG_REGIST,
    NEWDLG_RECENT,
    NEWDLG_DEFINED
};

/* グリッド設定ダイアログ */

enum DLG_GRIDOPT
{
    GRIDOPT_TITLE,
    GRIDOPT_GRID,
    GRIDOPT_GRIDSPLIT,
    GRIDOPT_COLSPLIT,
    GRIDOPT_ROWSPLIT,
    GRIDOPT_1PXGRID
};

/* テキスト描画 */

enum DLG_DRAWTEXT
{
    DTEXT_TITLE,
    DTEXT_PREVIEW,
    DTEXT_STYLE,
    DTEXT_SIZE,
    DTEXT_CHARSPACE,
    DTEXT_LINESPACE,
    DTEXT_VERT,
    DTEXT_2COL,
    DTEXT_HINTING,
    DTEXT_HINT,

    DTEXT_HT_NONE = 100,
    DTEXT_HT_NORMAL,
    DTEXT_HT_LIGHT,
    DTEXT_HT_MAX
};

/* グラデーション編集 */

enum DLG_GRADEDIT
{
    GRADEDIT_TITLE,
    GRADEDIT_COLOR,
    GRADEDIT_POS,
    GRADEDIT_DRAWCOL,
    GRADEDIT_BACKCOL,
    GRADEDIT_SPECCOL,
    GRADEDIT_OPACITY,
    GRADEDIT_LOOP,
    GRADEDIT_SINGLE,
    GRADEDIT_HELP,
};

};

#endif
