/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_FILTERDRAWFUNC_H_
#define _AZPT_FILTERDRAWFUNC_H_

class CTileImage;
struct FILTERDRAW;

#define _GETV(r,g,b)  (((r) * 77 + (g) * 150 + (b) * 29) >> 8)

//

namespace filterdraw
{

typedef struct
{
    double mul[9],divmul,add;
}FILTER3X3DAT;

typedef struct
{
    CTileImage *pimgDst,*pimgSrc;
    int radius,coltype,opacity,masktype;
}DRAWPOINTDAT;

typedef BOOL (*COMMON1FUNC)(FILTERDRAW &info,RGBAFIX15 *,int,int);
typedef void (CTileImage::*TILEIMGPIXFUNC)(int,int,const RGBAFIX15 &);
typedef void (*DRAWPOINTFUNC)(int,int,const DRAWPOINTDAT &);


//[sub]

BOOL clipInCanvas(RECTANDSIZE *prs,FILTERDRAW &info);
CTileImage *allocTmpImage(FILTERDRAW &info,const RECTANDSIZE &rs);
void getDrawColor(RGBAFIX15 *pcol,int type);
void copyRect(FILTERDRAW &info);

void addAdvColor(double *pcol,const RGBAFIX15 &col);
void addAdvColor(double *pcol,CTileImage *pimg,int x,int y,BOOL bClip);
void addAdvColor(double *pcol,double weight,CTileImage *pimg,int x,int y,BOOL bClip);
void getAdvColor(RGBAFIX15 *pdst,double *pcol,double weightmul);

void getLinerCol(RGBAFIX15 *pcol,CTileImage *pimg,double dx,double dy,int mode);
void getLinerColBkgnd(RGBAFIX15 *pcol,CTileImage *pimg,double dx,double dy,int x,int y,int bktype);

BOOL tmpGaussBlur(const FILTERDRAW &info,CTileImage *pimgSrc,CTileImage *pimgDst,int radius,TILEIMGPIXFUNC funcPix);

void RGBtoYCrCb(int *pcol);
void YCrCbtoRGB(int *pcol);
void RGBtoHSV(int *pcol);
void HSVtoRGB(int *pcol);
void HSVtoRGB_hue(RGBAFIX15 *pcol,int hue);

//[sub2]

BOOL common1(FILTERDRAW &info,COMMON1FUNC func);
BOOL filter3x3(FILTERDRAW &info,const FILTER3X3DAT &dat,BOOL bGrayscale=FALSE);

void getDrawPointFunc(DRAWPOINTFUNC *pfunc,int type);

//[color]

BOOL color_brightcont(FILTERDRAW &info);
BOOL color_gamma(FILTERDRAW &info);
BOOL color_level(FILTERDRAW &info);
BOOL color_rgb(FILTERDRAW &info);
BOOL color_hsv(FILTERDRAW &info);
BOOL color_nega(FILTERDRAW &info);
BOOL color_grayscale(FILTERDRAW &info);
BOOL color_sepia(FILTERDRAW &info);
BOOL color_threshold(FILTERDRAW &info);
BOOL color_threshold_dither(FILTERDRAW &info);
BOOL color_posterize(FILTERDRAW &info);
BOOL color_gradmap(FILTERDRAW &info);

BOOL colorop_drawcol_rep(FILTERDRAW &info);
BOOL colorop_common(FILTERDRAW &info);

BOOL alphaop1_common(FILTERDRAW &info);
BOOL alphaop2_common(FILTERDRAW &info);

//[blur]

BOOL blur_blur(FILTERDRAW &info);
BOOL blur_gauss(FILTERDRAW &info);
BOOL blur_motion(FILTERDRAW &info);
BOOL blur_radial(FILTERDRAW &info);
BOOL blur_lens(FILTERDRAW &info);

//[draw]

BOOL draw_frame(FILTERDRAW &info);
BOOL draw_line(FILTERDRAW &info);
BOOL draw_check(FILTERDRAW &info);
BOOL draw_amitone(FILTERDRAW &info,double len);
BOOL draw_amitone1(FILTERDRAW &info);
BOOL draw_amitone2(FILTERDRAW &info);
BOOL draw_edge(FILTERDRAW &info);
BOOL draw_rndpoint(FILTERDRAW &info);
BOOL draw_cloud(FILTERDRAW &info);

//[effect]

BOOL eff_glow(FILTERDRAW &info);
BOOL eff_rgbshift(FILTERDRAW &info);
BOOL eff_oilpaint(FILTERDRAW &info);
BOOL eff_emboss(FILTERDRAW &info);
BOOL eff_noise(FILTERDRAW &info);
BOOL eff_diffusion(FILTERDRAW &info);
BOOL eff_scratch(FILTERDRAW &info);
BOOL eff_median(FILTERDRAW &info);
BOOL eff_blurring(FILTERDRAW &info);

//[trans]

BOOL trans_wave(FILTERDRAW &info);
BOOL trans_ripple(FILTERDRAW &info);
BOOL trans_polar(FILTERDRAW &info);
BOOL trans_radialshift(FILTERDRAW &info);
BOOL trans_swirl(FILTERDRAW &info);

//[comic]

BOOL comic_concline_flash(FILTERDRAW &info);
BOOL comic_popupflash(FILTERDRAW &info);
BOOL comic_uniflash(FILTERDRAW &info);
BOOL comic_uniflash_wave(FILTERDRAW &info);

//[etc1]

BOOL mozaic(FILTERDRAW &info);
BOOL crystal(FILTERDRAW &info);
BOOL halftone(FILTERDRAW &info);
BOOL sharp(FILTERDRAW &info);
BOOL unsharpmask(FILTERDRAW &info);
BOOL highpass(FILTERDRAW &info);
BOOL edge_sobel(FILTERDRAW &info);
BOOL edge_laplacian(FILTERDRAW &info);
BOOL lumtoalpha(FILTERDRAW &info);
BOOL button3D(FILTERDRAW &info);
BOOL shift(FILTERDRAW &info);

//[etc2]

BOOL dotthinning(FILTERDRAW &info);
BOOL hemming(FILTERDRAW &info);

BOOL antialiasing(FILTERDRAW &info);

};

#endif
