/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_FILTERDRAW_H_
#define _AZPT_FILTERDRAW_H_

#include "struct.h"

class CTileImage;
class CTileImageA1;
class CProgressDlg;
struct FILTERDRAW;

typedef BOOL (*FILTERDRAWFUNC)(FILTERDRAW &);

struct FILTERDRAW
{
    RECTANDSIZE     rs;
    CTileImage      *pimgSrc,
                    *pimgDst,
                    *pimgRef;
    CTileImageA1    *pimgSel;
    CProgressDlg    *pProgDlg;

    FILTERDRAWFUNC  funcDraw;

    BOOL    bPreview,
            bClipping,
            bCopySrc;
    int     valbar[8],
            valcombo[3],
            valcheck[3],
            ntmp[5],
            tmpx,
            tmpy;
    double  dtmp[1];
    DWORD   dwDrawCol;

    //

    BOOL isPrev() { return bPreview; }
    void progSetMax(int max);
    void progBeginOneStep(int step,int max);
    void progBeginSub(int step,int max);
    void progInc();
    void progIncSub();
};

#endif
