/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAWDAT_H_
#define _AZPT_DRAWDAT_H_

#include "drawVIEW.h"
#include "AXString.h"

class CXImage;
class CImageRGB16;
class CImage8;
class CTileImage;
class CTileImageA1;
class CLayerList;
class CLayerItem;
class CPolygonPaint;
class CFont;
class CPosBuf;
class CUndo;
class AXConfRead;
class AXConfWrite;

//

namespace draw
{

enum
{
    IMGSIZE_MAX     = 9999,
    SCALE_MIN       = 50,
    SCALE_MAX       = 12000,
    BLENDMODE_NUM   = 17,
    DOTPENLIST_NUM  = 5
};

enum LOADERR
{
    LOADERR_SUCCESS,
    LOADERR_ETC,
    LOADERR_IMGSIZE,    //画像サイズエラー
    LOADERR_OPENFILE,   //ファイルが開けない
    LOADERR_FORMAT      //フォーマットエラー
};

enum TOOL
{
    TOOL_BRUSH,
    TOOL_DOTPEN,
    TOOL_POLYPAINT,
    TOOL_POLYERASE,
    TOOL_PAINT,
    TOOL_PAINTERASE,
    TOOL_GRAD,
    TOOL_TEXT,
    TOOL_MAGICWAND,
    TOOL_SEL,
    TOOL_BOXEDIT,
    TOOL_MOVE,
    TOOL_CANVROTATE,
    TOOL_CANVMOVE,
    TOOL_SCALE,
    TOOL_SPOIT,

    TOOL_NUM
};

enum DRAWTYPE
{
    DRAWTYPE_FREE,
    DRAWTYPE_LINE,
    DRAWTYPE_BOX,
    DRAWTYPE_CIRCLE,
    DRAWTYPE_SUCCLINE,
    DRAWTYPE_CONCLINE,
    DRAWTYPE_BEZIER,

    DRAWTYPE_NUM
};

enum RULETYPE
{
    RULETYPE_NONE,
    RULETYPE_LINE,
    RULETYPE_GRIDLINE,
    RULETYPE_CONCLINE,
    RULETYPE_CIRCLE,
    RULETYPE_ELLIPSE
};

enum DTEXTFLAGS
{
    DTEXTF_PREVIEW  = 1,
    DTEXTF_VERT     = 2,
    DTEXTF_2COL     = 4
};

//------------------

//! ツール関連

struct TOOLDAT
{
    int     toolno;
    BYTE    toolSubNo[TOOL_NUM],
            btDotPenListSel,
            optMove,    //[0-2bit]タイプ [3bit]リンク無効
            optSel;

    WORD    optPolyPaint,   //[0-7bit]濃度 [8-10]塗り [11]アンチエイリアス
            optPolyErase,
            optMagicWand,   //[0-2bit]判定 [3-12bit]あまさ
            headtail[2];    //入り抜き ([0]直線 [1]ベジェ)

    DWORD   dwDotPenList[DOTPENLIST_NUM],
            optPaint,       //[0-2bit]判定 [3-5bit]塗り [6-12bit]濃度 [13-22bit]あまさ
            optGrad;        //[0-7bit]濃度 [8-10]塗り [11]カスタム [12]反転 [13]繰り返し [16-23]カスタム選択

    BOOL isBrushOrDotPen() { return (toolno == TOOL_BRUSH || toolno == TOOL_DOTPEN); }
};

//! 描画作業用

struct WORKDAT
{
    int     nNowOpNo,
            nOpAfter,
            nOpAfter2,
            nOpToolNo,      //操作中のツール番号
            nTmp[2];

    UINT    uBttDown,
            uModDown,
            uOpFlags,
            optDrawTmp;

    ULONGLONG   timeMidCol;
    RGBFIX15    colMidCol;

    CLayerItem  *pLayer;
    void        *pTmp;

    DRAWPOINT   ptWinDown,
                ptWinNow,
                ptWinBk;
    DPOINT      dptTmp[1];
    AXPoint     ptTmp[4];
    AXRectSize  rcsTmp[1];
    FLAGRECT    rcfDrawUp,
                rcfSel,
                rcfTmp[1];

    TILEIMGINFO     infoImgUndo;
    BRUSHDRAWPARAM  brparam;

    void (*funcMove)(UINT);
    BOOL (*funcUp)();
    void (*funcUpdatePrev)(const AXRectSize &);
};

//! 定規データ

struct RULEDAT
{
    int     type,
            bEllRevH,       //!< [楕円]左右反転か
            nTmp;           //!< 作業用（[格子線]角度確定フラグ）
    AXPoint ptCtConc,       //!< 中心位置(集中線)
            ptCtCir,        //!< 中心位置(正円)
            ptCtEll;        //!< 中心位置(楕円)
    DPOINT  ptDown;         //!< 押し時のイメージ位置
    double  dTmp,           //!< 共通作業用([集中線]角度、[円]半径、[格子線]確定角度)
            dAngleLine,     //!< [平行線]角度
            dAngleGrid,     //!< [格子線]基本の角度
            dEllHV[2],      //!< [楕円]扁平率(0:x/y,1:y/x)
            dEllTmp[4];     //!< [楕円]回転
};

//! テキスト描画データ

struct DRAWTEXTDAT
{
    AXString    strText,
                strFontFace,
                strFontStyle;
    int         nSize,
                nCharSpace,
                nLineSpace,
                nHinting;
    UINT        uFlags;

    BOOL isPreview() { return uFlags & DTEXTF_PREVIEW; }
    BOOL is2col() { return uFlags & DTEXTF_2COL; }
    BOOL isVert() { return uFlags & DTEXTF_VERT; }
};

//----------------

//! メインデータ

struct MAINDAT
{
    int     nImgW,nImgH,        //!< イメージサイズ
            nImgDPI,
            nSaveTPCol;         //!< 保存時の透過色（-1でなし）

    CLayerItem  *pcurlayer;     //!< カレントレイヤ

    RGBAFIX15   colDraw,
                colBack;

    //

    CXImage     *pimgCanvas;    //!< CCanvasWinArea の表示部分
    CImageRGB16 *pimgBlend;     //!< 全レイヤ合成後のイメージ（nImgW x nImgH）
    CTileImage  *pimgUndo,      //!< アンドゥ用イメージ
                *pimgTmp[2];
    CImage8     *pimg8DotBrush, //!< ドットペン描画用ブラシデータ
                *pimg8OptTex;   //!< オプションテクスチャ画像
    CTileImageA1 *pimgXor,
                 *pimgSel;

    CLayerList      *player;
    CPolygonPaint   *pPolyPaint;
    CFont           *pfont;
    CPosBuf         *pPosBuf;
    CUndo           *pundo;

    TILEIMGDRAWINFO drawinfo;   //!< CTileImage 描画関連情報

    VIEW        view;
    TOOLDAT     tool;
    WORKDAT     work;
    RULEDAT     rule;
    DRAWTEXTDAT text;

    void (*funcBlendCol[BLENDMODE_NUM])(RGBAFIX15 *,const RGBFIX15 &);

    //---------

    MAINDAT();
    ~MAINDAT();

    BOOL isNowOpNone() { return !work.nNowOpNo; }
    BOOL isCanvasHRev() { return view.bHRev; }

    void loadConfig(AXConfRead *pcf);
    void saveConfig(AXConfWrite *pcf);
};

};

#endif
