/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    操作時、内部で使うサブ処理関数
*/

namespace draw
{

enum
{
    CHECKDRAW_OK,
    CHECKDRAW_FOLDER,
    CHECKDRAW_LOCK
};

//

int checkDrawLayer();
void getNowPoint(AXPoint *ppt);
void getNowImgPoint(AXPoint *ppt);
void setStatusBar_line(const AXPoint &pt1,const AXPoint &pt2);
void setOpInfo(int opno,void (*funcMove)(UINT),BOOL (*funcUp)(),int afterno=-1);
void freeTmpTileImg(int no=0);
BOOL allocTmpTileImg(int no,const AXRect &rc);

void beginDrawUndo();
void endDrawUndo(const AXRectSize &rcs);

void beginDraw();
void endDraw();
void commonFreeDraw(BOOL bTimer=TRUE);
void commonDrawEnd();
void commonAfterDraw();

void setBeforeDraw(int toolno,int brushno=-1);
void setBeforeDraw_clearMask();
void setBeforeDraw_brush(int brushno);
void setBeforeDraw_selImgMove(BOOL bOverwrite);
void setBeforeDraw_selBrush();
void setBeforeDraw_dotpen(int listno);
void setBeforeDraw_filter(BOOL bPrev);
void setBeforeDraw_filterDrawFlash();

void getDrawPoint(DRAWPOINT *pdst,BOOL bEnableRule=FALSE,BOOL bRuleInt=FALSE);
void getDrawPointInt(AXPoint *ppt,BOOL bEnableRule);

};
