/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAW_FILE_H_
#define _AZPT_DRAW_FILE_H_

#define _8TO16COL(c)   ((((c) << 15) + 127) / 255)
#define _16TO8COL(c)   (BYTE)(((c) * 255 + 0x4000) >> 15)

namespace draw
{

enum
{
    SAVERET_OK,
    SAVERET_ERR
};

//apd

int saveAPD(const AXString &filename,CProgressDlg *pProgDlg);
int loadAPD(const AXString &filename,CProgressDlg *pProgDlg);

//adw

int loadADW(const AXString &filename,CProgressDlg *pProgDlg);

//psd

int loadPSD(const AXString &filename,CProgressDlg *pProgDlg);
int errPSDtoLOAD(int err);

int savePSD(const AXString &filename,CProgressDlg *pProgDlg);
int savePSD_nolayer(const AXString &filename,int type,CProgressDlg *pProgDlg);

//etc

int savePNG_alpha(const AXString &filename,CProgressDlg *pProgDlg);

};

#endif
