/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DIALOG_LAYER_H_
#define _AZPT_DIALOG_LAYER_H_

#include "AXDialog.h"
#include "AXString.h"

class AXLineEdit;
class AXComboBox;
class AXCheckButton;
class AXColorButton;

//! 新規レイヤダイアログ

class CNewLayerDlg:public AXDialog
{
public:
    typedef struct
    {
        AXString    strName;
        int         nBlendMode,
                    nColType;
        DWORD       dwCol;
    }INFO;

protected:
    INFO    *m_pInfo;

    AXLineEdit  *m_peditName;
    AXComboBox  *m_pcbBlend;
    AXColorButton   *m_pbtCol;

    enum{ WID_COLTYPE = 100 };

public:
    CNewLayerDlg(AXWindow *pOwner,INFO *pInfo);

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! カラータイプ変更ダイアログ

class CLayerColTypeDlg:public AXDialog
{
protected:
    int     m_nInitType;
    AXCheckButton   *m_pckType[4],
                    *m_pckLum;

    enum{ WID_TYPE = 100 };

public:
    CLayerColTypeDlg(AXWindow *pOwner,int nInitType);

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 複数レイヤ結合ダイアログ

class CLayerCombineSomeDlg:public AXDialog
{
public:
    typedef struct
    {
        int type,coltype;
        BOOL bFolder,bCheckExist,bNewLayer;
    }INFO;

protected:
    INFO *m_pinfo;

    AXCheckButton   *m_pckType[3],
                    *m_pckNewLayer;
    AXComboBox      *m_pcbColType;

    enum
    {
        WID_TYPE = 100,
        WID_NEWLAYER = 200
    };

public:
    CLayerCombineSomeDlg(AXWindow *pOwner,INFO *pInfo);

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

#endif
