/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_XIMAGE_H_
#define _AZPT_XIMAGE_H_

#include "AXImage.h"

class AXRect;
class AXRectSize;
struct DRAWCANVASINFO;

class CXImage:public AXImage
{
protected:
    void _drawGridLine(double x1,double y1,double x2,double y2,DWORD col,const AXRect &rcClip);
    int _calcClipCode(double x,double y,const AXRect &rcClip);

public:
    void drawCheckTwo(int x,int y,int size);
    void drawDashLineH(int y,const AXRectSize &rcs);
    void drawDashLineV(int x,const AXRectSize &rcs);
    void drawDashBox(int x,int y,int w,int h);
    void drawAlphabet(int x,int y,DWORD col,LPCSTR szText);

    void setPixelSelection(int x,int y,const AXRect &rcClip);
    void drawLineSelection(int x1,int y1,int x2,int y2,const AXRect &rcClip);
    void drawLineBlend(double x1,double y1,double x2,double y2,DWORD col);
    void drawGrid(const AXRectSize &rcsDst,const AXRectSize &rcsImg,int gridw,int gridh,DWORD colGrid,const DRAWCANVASINFO &info);
};

#endif
