/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_UNDODAT_H_
#define _AZPT_UNDODAT_H_

#include "AXUndoDat.h"

#include "CUndoDatBuf.h"

class CLayerItem;
class CTileImage;
class CUndo;
struct FLAGRECT;
struct TILEIMGINFO;


class CUndoDat:public AXUndoDat
{
    friend class CUndo;

public:
    enum COMMAND
    {
        CMD_UNDOIMG,
        CMD_UNDOIMG_SMALL,
        CMD_LAYER_NEW,
        CMD_LAYER_COPY,
        CMD_LAYER_DEL,
        CMD_LAYER_CLEAR,
        CMD_LAYER_COLTYPE,
        CMD_LAYER_MOVE,
        CMD_LAYER_COMBINE,
        CMD_LAYER_COMBINEMUL,
        CMD_LAYER_OFFSET,
        CMD_LAYER_HVREV,
        CMD_LAYER_ROTATE90,
        CMD_LAYER_FLAGS,
        CMD_CANVAS_RESIZE,
        CMD_CANVAS_SCALE
    };

    enum{ VAL_CNT = 5 };

protected:
    int         m_nCommand,         //!< コマンドNo
                m_nVal[VAL_CNT];    //!< 各値
    CUndoDatBuf m_dat;

private:
    CLayerItem *_getLayer(int no);
    CLayerItem *_getLayer(int pno,int no);
    CTileImage *_getLayerImg(int no);

    void _setUpdateRect(CUndo *pundo,const FLAGRECT &rcf);
    void _setUpdateRect(CUndo *pundo,CLayerItem *pItem);

    void _deleteLayer(CLayerItem *p);

    int _getUndoImageSize(CTileImage *pimg,LPDWORD pTileCnt);
    int _getUndoImageRevSize(CTileImage *pimg,BOOL bRedo);

    BOOL _run_layerNew(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerCopy(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerDel(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerClear(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerColType(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerCombine(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerCombineMul(CUndo *pundo,BOOL bUndo);
    BOOL _run_layerDelete(CUndo *pundo,CLayerItem *p);
    void _run_layerMove(CUndo *pundo);
    void _run_layerHVRev(CUndo *pundo);
    void _run_layerRotate90(CUndo *pundo);
    BOOL _run_layerOffset(CUndo *pundo);
    BOOL _run_canvasScale(CUndo *pundo,BOOL bUndo);
    BOOL _run_sub_combineAll(CUndo *pundo,BOOL bUndo);
    BOOL _run_undoImage(BOOL bRedo);

protected:
    CUndoDat(int cmd);

    virtual BOOL run(AXUndo *pUndo,BOOL bUndo);
    virtual BOOL setReverseDat(AXUndo *pUndo,AXUndoDat *pSrc,BOOL bUndo);

    void setval_curlayer(int valno=0);
    void setval_layerno(int valno,CLayerItem *pItem);
    void setval_layerno_parent(int valno,CLayerItem *pItem);

    //

    BOOL writeLinkLayersNO(CLayerItem *pTop,int cnt);
    BOOL writeLayerOnlyImage(CLayerItem *pItem);
    BOOL writeLayerTwoImage(CLayerItem *pItem);
    BOOL writeLayerCombine(BOOL bUndo);
    BOOL writeLayerSingle(CLayerItem *pItem);
    BOOL writeLayerFolder(CLayerItem *pItem);
    BOOL writeLayerAll();

    void writeLayerInfo(CLayerItem *pItem);
    void writeLayerImage(CTileImage *pimg);

    BOOL writeImageSmall(CTileImage *pimg,BOOL bFirst);
    BOOL writeUndoImage(const TILEIMGINFO &info);
    BOOL writeUndoImageRev(CUndoDat *pSrc,BOOL bRedo);

    //

    BOOL restoreLayerOnlyImage(CLayerItem *pItem);
    BOOL restoreLayerTwoImage(CLayerItem *pItem);
    BOOL restoreLayerCombine(BOOL bUndo,FLAGRECT *prcf);
    BOOL restoreLayerSingle(int pno,int no,FLAGRECT *prcf);
    BOOL restoreLayerMul(FLAGRECT *prcf);

    BOOL restoreLayer(int pno,int no,FLAGRECT *prcf);
    BOOL restoreLayerInfoAndImage(CLayerItem *pitem,FLAGRECT *prcf);
    BOOL restoreImage(CLayerItem *pItem);

    BOOL restoreImageSmall();
};

#endif
