/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_UNDO_H_
#define _AZPT_UNDO_H_

#include "AXUndo.h"
#include "AXRect.h"

class CTileImage;
class CLayerItem;
class CUndoDat;
struct TILEIMGINFO;


class CUndo:public AXUndo
{
    friend class CUndoDat;

public:
    enum
    {
        UPDATE_RECT,
        UPDATE_RECTANDLAYER,
        UPDATE_ALL,
        UPDATE_ALLANDLAYER,
        UPDATE_LAYERLIST,
        UPDATE_RESIZE
    };

protected:
    BOOL        m_bChange;
    int         m_nUpdateType;
    AXRectSize  m_rcsUpdate;

protected:
    virtual AXUndoDat *createDat();
    virtual void afterAddUndo();
    CUndoDat *_addundo(int cmd);

public:
    CUndo();

    BOOL isChange() const { return m_bChange; }
    void setChangeNone() { m_bChange = FALSE; }

    void getUpdateParam(LPINT ptype,AXRectSize *prcs)
    {
        *ptype = m_nUpdateType;
        *prcs  = m_rcsUpdate;
    }

    void add_curLayerUndoImage(const TILEIMGINFO &info,const AXRectSize &rcs);
    void add_layerNew();
    void add_layerCopy();
    void add_layerDel();
    void add_layerClear();
    void add_layerColType(CLayerItem *pItem,int coltype,BOOL bLum);
    void add_layerCombine(BOOL bDrop);
    void add_layerCombineMul(int type);
    void add_layerMove(CLayerItem *pItem,int *bkno);
    void add_layerHVRev(BOOL bHorz);
    void add_layerRotate90(BOOL bLeft);
    void add_layerFlags(CLayerItem *pItem,DWORD dwFlag);
    void add_layerOffset(int movx,int movy,CLayerItem *pTop,int linkcnt);

    void add_resizeCanvas(int addx,int addy,int imgw,int imgh);
    void add_scaleCanvas();
};

#endif
