/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_TOOLWIN_H_
#define _AZPT_TOOLWIN_H_

#include "AXTopWindow.h"

class AXToolBar;
class CScaleRotBar;

class CToolWin:public AXTopWindow
{
public:
    static CToolWin *m_pSelf;

    enum CMDID
    {
        CMDID_TOOL    = 1000,
        CMDID_TOOLSUB = 2000
    };

    enum
    {
        TOOLSUB_DRAW = 0,
        TOOLSUB_POLYGON,
        TOOLSUB_GRAD,
        TOOLSUB_SEL,
        TOOLSUB_BOXEDIT,
        TOOLSUB_SCALE,

        TOOLSUB_NUM
    };

protected:
    AXToolBar   *m_ptbTool,
                *m_ptbSub[TOOLSUB_NUM],
                *m_ptbSubNow;
    CScaleRotBar    *m_pwidScale,
                    *m_pwidRot;

protected:
    void _createTB_tool();
    void _createTB_sub();
    void _initTB_sub();

public:
    CToolWin(AXWindow *pOwner,UINT addstyle);

    void showToggle();
    void changeTool();
    void changeScale();
    void changeRotate();
    void checkTB_tool(int no);
    void checkTB_toolsub_pen(int no);

    virtual BOOL onClose();
    virtual BOOL onCommand(UINT uID,ULONG lParam,int from);
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

#define TOOLWIN (CToolWin::m_pSelf)

#endif
