/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_RESIZECANVAS_H_
#define _AZPT_RESIZECANVAS_H_

#include "AXDef.h"

class CProgressDlg;
class CImageRGB16;
class AXZlib;

class CResizeCanvas
{
protected:
    CImageRGB16  *m_pimg;
    CProgressDlg *m_pProgDlg;

    double  *m_pWeight;
    short   *m_pIndex;
    AXSize  m_szOld,
            m_szNew;
    int	    m_nType,
            m_nTap;

protected:
    void _freeParam();

    BOOL _resizeV(void *pLineBuf);
    void _resizeV_nearest(AXZlib *pzlib);
    void _resizeV_etc(AXZlib *pzlib,void *pLineBuf);

    BOOL _resizeH(void *pLineBuf);
    BOOL _resizeH_nearest(AXZlib *pzlib,void *pLineBuf);
    BOOL _resizeH_etc(AXZlib *pzlib,void *pLineBuf);

    BOOL _allocParam(int len);
    BOOL _setParam(int srcl,int dstl);
    BOOL _setParam_down(int srcl,int dstl);
    BOOL _setParam_up(int srcl,int dstl);
    double _getWeight(double d);

public:
    CResizeCanvas();
    ~CResizeCanvas();

    BOOL run(CImageRGB16 *pimg,const AXSize &sizeOld,const AXSize &sizeNew,int type,CProgressDlg *pProgDlg);
};

#endif
