/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    オプションウィンドウの各タブ
*/


//------------------ サブ

//! ドットペン・リスト

class COptWin_dotpen_list:public AXWindow
{
protected:
    AXImage m_img;

    enum{ ONEW = 23 };

public:
    COptWin_dotpen_list(AXWindow *pParent,UINT uID);

    void draw();

    BOOL onPaint(AXHD_PAINT *phd);
    BOOL onButtonDown(AXHD_MOUSE *phd);
};

//! 定規・タイプ

class COptWin_rule_type:public AXWindow
{
    AXImage   m_img;

    void setImage();

public:
    COptWin_rule_type(AXWindow *pParent);
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

//------------------ ツール

//! ドットペン

class COptWin_dotpen:public AXWindow
{
    enum
    {
        WID_LIST = 100,
        WID_CB_TYPE,
        WID_BAR_SIZE,
        WID_BAR_OPACITY
    };

    COptWin_dotpen_list *m_pwidList;
    AXComboBox  *m_pcbType;
    CValBar     *m_pbarSize,
                *m_pbarOpa;

public:
    COptWin_dotpen();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 図形塗りつぶし/消去

class COptWin_polypaint:public AXWindow
{
    CValBar     *m_pbarOpa;
    AXComboBox  *m_pcbPix;
    BOOL        m_bErase;

    enum
    {
        WID_OPACITY = 100,
        WID_PIXTYPE,
        WID_ANTIALIAS
    };

public:
    COptWin_polypaint();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 塗りつぶし

class COptWin_paint:public AXWindow
{
    enum
    {
        WID_TYPE = 100,
        WID_DIFF,
        WID_OPACITY,
        WID_PIXTYPE
    };

    AXComboBox  *m_pcbType,
                *m_pcbPix;
    CValBar     *m_pbarDiff,
                *m_pbarOpa;

public:
    COptWin_paint();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! グラデーション

class COptWin_grad:public AXWindow
{
    enum
    {
        WID_CK_DEFAULT = 100,
        WID_CK_CUSTOM,
        WID_CB_CUSTOM,
        WID_BT_CUSTOM,
        WID_OPACITY,
        WID_PIXTYPE,
        WID_REVERSE,
        WID_LOOP
    };

    AXCheckButton   *m_pckDefault,
                    *m_pckCustom;
    CValBar         *m_pbarOpa;
    AXComboBox      *m_pcbPix;
    CCustomGradSel  *m_pCustom;

    void _runCustomMenu();
    void _editCustom();

public:
    COptWin_grad();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 自動選択

class COptWin_magicwand:public AXWindow
{
    enum
    {
        WID_TYPE = 100,
        WID_DIFF
    };

    AXComboBox  *m_pcbType;
    CValBar     *m_pbarDiff;

public:
    COptWin_magicwand();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 選択範囲

class COptWin_sel:public AXWindow
{
    enum
    {
        WID_ADD = 100,
        WID_DEL
    };

public:
    COptWin_sel();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 移動

class COptWin_move:public AXWindow
{
    enum
    {
        WID_DISABLE_LINK = 100,
        WID_TYPE_TOP = 110
    };

public:
    COptWin_move();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//--------------------

//! 定規

class COptWin_rule:public AXWindow
{
    enum
    {
        WID_BTT_ANGLE = 100,
        WID_BTT_POS
    };

    COptWin_rule_type   *m_pwidType;

    void _enableBtt();
    void _menuAngle();
    void _menuPos();

public:
    COptWin_rule();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! テクスチャ

class COptWin_texture:public AXWindow
{
    CSelImgBar  *m_pSel;
    CImgPrev    *m_pPrev;

    void _setImage();

public:
    COptWin_texture();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 入り抜き

class COptWin_headtail:public AXWindow
{
    enum
    {
        WID_CK_LINE = 100,
        WID_CK_BEZIER,
        WID_EDIT_HEAD,
        WID_EDIT_TAIL,
        WID_BT_REGIST,
        WID_LIST,
    };

    AXListBox   *m_pList;
    AXLineEdit  *m_pedit[2];

    void _setVal(WORD val);
    void _setListVal();

public:
    COptWin_headtail();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//! 設定

class COptWin_option:public AXWindow
{
    enum
    {
        WID_CB_IMGBK = 100,
        WID_BTT_IMGBK
    };

    AXComboBox  *m_pcbImgBk;

public:
    COptWin_option();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
    virtual BOOL onOwnerDraw(AXDrawable *pdraw,AXHD_OWNERDRAW *phd);
};
