/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_MAINWIN_H_
#define _AZPT_MAINWIN_H_

#include "AXTopWindow.h"
#include "AXString.h"

class AXMenu;
class AXToolBar;
class CLayerItem;

class CMainWin:public AXTopWindow
{
    friend class CLayerWinArea;

public:
    static CMainWin *m_pSelf;

public:
    enum FILEFORMAT
    {
        FILEFORMAT_ALL = -1,

        FILEFORMAT_APD = 0,
        FILEFORMAT_PSD,
        FILEFORMAT_BMP,
        FILEFORMAT_PNG,
        FILEFORMAT_JPEG,
        FILEFORMAT_GIF,
        FILEFORMAT_PSD_8BITRGB,
        FILEFORMAT_PSD_GRAYSCALE,
        FILEFORMAT_PSD_MONOCHROME,
        FILEFORMAT_PNG_ALPHA,

        FILEFORMAT_EXPORT_NUM,
        FILEFORMAT_ADW
    };

protected:
    UINT        m_uTmpFlags;
    int         m_nFileFormat;  //!< 編集ファイルの画像フォーマット
    AXString    m_strFileName;  //!< 編集ファイル名

    AXToolBar   *m_pToolBar;
    AXMenu      *m_pmenuRecFile;    //!< 最近使ったファイルのメニュー

    enum
    {
        CMDID_MENU_RECENTFILE = 0x00010000,

        TMPFLAG_SHOW          = 1,
        TMPFLAG_MAXIMIZE_INIT = 2
    };

protected:
    void _createMenu();
    void _createToolBar();
    void _setAccelerator();
    void _runScaleMenu();

    //[file]

    int _save_overwrite();
    int _getFileFormat(const AXString &filename);
    void _getSaveFilterString(AXString *pstr,int format);
    void _setFormatExt(AXString *pstr,int format);
    void _errMes_save(int ret);

    void _addRecentFile(const AXString &filename);
    int _runRecentDirMenu(AXString *pstrArray,int cnt,int bttid);
    void _runRecOpenDirMenu();
    void _runRecSaveDirMenu();
    void _runTBExportMenu();

    //[layer]

    BOOL _cmd_layer(UINT id);
    void _layerRename(CLayerItem *pItem);
    void _layerNew();
    void _layerNewFolder();
    void _layerFromImg();
    void _layerChangeColType(CLayerItem *pItem);
    void _layerCombineSome();
    void _layerSave();

    void _command_ex(UINT id);

    //[filter]

    void _command_filter(UINT id,int from);

public:
    virtual ~CMainWin();
    CMainWin();

    BOOL isShowMain() { return (m_uTmpFlags & TMPFLAG_SHOW) && !(m_uTmpFlags & TMPFLAG_MAXIMIZE_INIT); }
    const AXString& getEditFileName() const { return m_strFileName; }

    //

    void showMainWin();

    void updateNewCanvas(AXString *pstr);
    BOOL checkImageUpdate();
    void setWinTitle();
    void getFileInitDir(AXString *pstr);

    void undoRedo(BOOL bRedo);
    void resizeCanvas();
    void scaleCanvas();
    void trimming();
    void changeDPI();
    void gridOption();
    void keyOption();
    void deviceOption();
    void envOption();
    void allWindowShowToggle();
    void runManual();

    //file

    void newImage();
    void openFile(const AXString *pstrDir=NULL);
    BOOL loadImage(const AXString &filename);
    BOOL saveFile(BOOL bRename,const AXString *pstrDir=NULL);
    void exportFile(int format,const AXString *pstrDir=NULL);

    //

    virtual BOOL onClose();
    virtual BOOL onMap();
    virtual BOOL onConfigure(AXHD_CONFIGURE *phd);
    virtual BOOL onDND_Drop(AXDND *pDND);
    virtual BOOL onCommand(UINT uID,ULONG lParam,int from);
    virtual BOOL onMenuPopup(AXMenuBar *pMenuBar,AXMenu *pMenu,UINT uID);
};

#define MAINWIN     (CMainWin::m_pSelf)

#endif
