/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_LAYERWIN_H_
#define _AZPT_LAYERWIN_H_

#include "AXTopWindow.h"

class AXToolBar;
class AXScrollBar;
class CLayerWinArea;
class CLayerWinInfo;
class CLayerItem;

class CLayerWin:public AXTopWindow
{
public:
    static CLayerWin *m_pSelf;

protected:
    CLayerWinInfo   *m_pwidInfo;
    AXToolBar       *m_pToolBar;
    CLayerWinArea   *m_pArea;
    AXScrollBar     *m_pScrV;

protected:
    void _createToolBar();

public:
    CLayerWin(AXWindow *pOwner,UINT addstyle);

    void showToggle();

    void updateLayerAll();
    void updateInfoParam();
    void updateCurLayer(BOOL bInfo);
    void updateLayerItem(CLayerItem *p);
    void updateShowCur();

    virtual BOOL onClose();
    virtual BOOL onCommand(UINT uID,ULONG lParam,int from);
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
    virtual BOOL onDND_Drop(AXDND *pDND);
};

#define LAYERWIN (CLayerWin::m_pSelf)

#endif
