/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_LAYERITEM_H_
#define _AZPT_LAYERITEM_H_

#include "AXTree.h"
#include "AXString.h"

class CTileImage;
class CProgressDlg;
struct TILEIMGINFO;
struct FLAGRECT;


class CLayerItem:public AXTreeItem
{
    friend class CLayerList;

public:
    enum FLAGS
    {
        FLAG_VISIBLE        = 0x0001,
        FLAG_EXPAND         = 0x0002,
        FLAG_LOCK           = 0x0004,
        FLAG_PAINT          = 0x0008,
        FLAG_LAYERMASK      = 0x0010,
        FLAG_LAYERMASKUNDER = 0x0020,
        FLAG_LINK           = 0x0040,
        FLAG_CHECK          = 0x0080
    };

    enum AMASKTYPE
    {
        AMASK_OFF,
        AMASK_KEEP,
        AMASK_A0,
        AMASK_ANOT0
    };

    enum COLTYPE
    {
        COLTYPE_RGBA,
        COLTYPE_GRAY,
        COLTYPE_A16,
        COLTYPE_A1
    };

public:
    CTileImage  *m_pimg;        //!< イメージ（NULLでフォルダ）

    AXString    m_strName;

    int         m_nOpacity,     //!< 不透明度[0-128]
                m_nColType,     //!< カラータイプ
                m_nAmaskType,   //!< Aマスクタイプ
                m_nBlendMode;   //!< 合成モード
    DWORD       m_dwFlags,
                m_dwCol;        //! レイヤ色

    CLayerItem  *m_pLink;       //! 移動ツール時などのリンク

protected:
    CLayerItem *_setLinkAndNext(CLayerItem **ppFirst,CLayerItem **ppBk,BOOL bEnableLock);
    void _setLink(CLayerItem **ppFirst,CLayerItem **ppBk);

public:
    CLayerItem();
    virtual ~CLayerItem();

    CLayerItem *next() { return (CLayerItem *)m_pNext; }
    CLayerItem *prev() { return (CLayerItem *)m_pPrev; }
    CLayerItem *parent() { return (CLayerItem *)m_pParent; }
    CLayerItem *first() { return (CLayerItem *)m_pFirst; }
    CLayerItem *last() { return (CLayerItem *)m_pLast; }

    BOOL isNormal() { return (m_pimg != NULL); }
    BOOL isFolder() { return !m_pimg; }
    BOOL isVisibleFlag() { return m_dwFlags & FLAG_VISIBLE; }
    BOOL isExpand() { return m_dwFlags & FLAG_EXPAND; }
    BOOL isLayerMask() { return m_dwFlags & FLAG_LAYERMASK; }
    BOOL isLayerMaskUnder() { return m_dwFlags & FLAG_LAYERMASKUNDER; }
    BOOL isLayerMaskOn() { return m_dwFlags & (FLAG_LAYERMASK|FLAG_LAYERMASKUNDER); }
    BOOL isLink() { return m_dwFlags & FLAG_LINK; }
    BOOL isCheck() { return m_dwFlags & FLAG_CHECK; }
    BOOL isPaint() { return m_dwFlags & FLAG_PAINT; }
    BOOL isLock() { return m_dwFlags & FLAG_LOCK; }

    BOOL isColTypeOnlyA() { return (m_nColType >= 2); }

    void expand() { m_dwFlags |= FLAG_EXPAND; }

    //

    void setLayerCol(DWORD col);
    void replaceImg(CTileImage *pNewImg);
    void copyInfo(const CLayerItem &src);

    CLayerItem *prevThisVisibleImg();
    CLayerItem *prevVisibleImg();
    CLayerItem *prevExpand();
    CLayerItem *prevNormal();
    CLayerItem *nextExpand();
    CLayerItem *nextVisibleImg(CLayerItem *pParent);

    int getDepth();
    BOOL isLockDraw();
    BOOL isVisibleView();
    int getViewOpacity();
    BOOL getVisibleImgRect(FLAGRECT *pDst);

    void visibleOn();
    BOOL reverseHorzVert(BOOL bHorz,FLAGRECT *prcf);
    BOOL rotate90(BOOL bLeft,FLAGRECT *prcf);

    BOOL saveAPLD(const AXString &filename,CProgressDlg *pdlg);
};

#endif
