/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_IMAGE32_H_
#define _AZPT_IMAGE32_H_

#include "AXImage32.h"

class AXString;
class AXImage;
class AXMem;
class AXRectSize;

class CImage32:public AXImage32
{
public:
    typedef struct
    {
        int     nDPI;
        BOOL    bAlpha;
    }LOADINFO;

    typedef struct
    {
        int     nBaseX,nBaseY,
                nScrollX,nScrollY;
        DWORD   dwExCol;
        double  dScaleDiv;
    }DRAWCANVASINFO;

public:
    BOOL loadImage(const AXString &filename,LOADINFO *pInfo);
    BOOL loadBMP(const AXString &filename,LOADINFO *pInfo);
    BOOL loadPNG(const AXString &filename,LOADINFO *pInfo);
    BOOL loadGIF(const AXString &filename,LOADINFO *pInfo);
    BOOL loadJPEG(const AXString &filename,LOADINFO *pInfo);

    BOOL createCursor(const AXString &filename,AXMem *pmem);

    void drawCanvasNormal(AXImage *pimgDst,const AXRectSize &rcsDst,const CImage32::DRAWCANVASINFO &info);
    void drawCanvasScaleDown(AXImage *pimgDst,const AXRectSize &rcsDst,const CImage32::DRAWCANVASINFO &info);
};

#endif
