/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_FILTERDLG_H_
#define _AZPT_FILTERDLG_H_

#include "AXDialog.h"
#include "struct.h"

class AXLayout;
class AXLineEdit;
class AXComboBox;
class AXBuf;
class CTileImage;
class CFilterBar;
class CFilterPrev;
class CFilterWidgetLevel;
class CProgressDlg;
class CFilterConfigItem;
struct FILTERDRAW;


class CFilterDlg:public AXDialog
{
public:
    enum
    {
        MAXNUM_BAR      = 8,
        MAXNUM_COMBO    = 3,
        MAXNUM_CHECK    = 3
    };

protected:
    FILTERDRAW  *m_pinfo;

    CTileImage  *m_pimgPrev,
                *m_pimgCurSave;
    FLAGRECT    m_rcfPrev;

    int     m_nPrevType,
            m_nBarCnt,
            m_nEditCnt,
            m_nComboCnt,
            m_nCheckCnt;
    BOOL    m_bPreview;
    UINT    m_uMenuID;
    BYTE    m_btTopFlags;

    short   m_sDefBar[MAXNUM_BAR];
    char    m_cSigBar[MAXNUM_BAR],
            m_cSigCombo[MAXNUM_COMBO],
            m_cSigCheck[MAXNUM_CHECK];

    CFilterConfigItem *m_pConfItem;

    CFilterBar          *m_pbar[MAXNUM_BAR];
    AXLineEdit          *m_peditBar[MAXNUM_BAR];
    AXComboBox          *m_pcombo[MAXNUM_COMBO];
    CFilterPrev         *m_pwidPrev;
    CFilterWidgetLevel  *m_pwidLevel;

protected:
    void _end(BOOL bOK);
    void _initPrev();
    void _prev();
    void _saveConfig();
    void _reset();

    void _create_widget(AXBuf *pbuf,int prevw,int prevh);
    void _create_subwidget(AXBuf *pbuf,AXLayout *plm);

    BOOL _create_bar(AXBuf *pbuf,AXLayout *plm,int size);
    BOOL _create_combo(AXBuf *pbuf,AXLayout *plm,int size);
    BOOL _create_check(AXBuf *pbuf,AXLayout *plm,int size);

    void _create_def_clipping(AXLayout *plm);
    void _create_def_level(AXLayout *plm);

public:
    CFilterDlg(AXWindow *pOwner,WORD wTitleID,const BYTE *pDat,FILTERDRAW *pinfo);
    virtual ~CFilterDlg();

    CTileImage *getPrevImg() { return m_pimgPrev; }

    virtual BOOL onClose();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
    virtual BOOL onTimer(UINT uTimerID,ULONG lParam);
    virtual BOOL onCommand(UINT uID,ULONG lParam,int from);
};

#endif
