/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_DRAWPAINT_H_
#define _AZPT_DRAWPAINT_H_

#include "CTileImageA1.h"

class CDrawPaint
{
public:
    enum
    {
        TYPE_RGB,
        TYPE_ALPHA,
        TYPE_ALPHA_AUTO,
        TYPE_CANVAS,
        TYPE_ERASE = 10
    };

    enum
    {
        RET_SUCCESS     = 0,
        RET_NODRAW      = 1,
        RET_ERR_MEMORY  = 2
    };

protected:
    enum { BUFSIZE = 8192 };

    struct PAINTBUF
    {
        short lx,rx,y,oy;
    };

protected:
    PAINTBUF    *m_pBuf;        //!< 塗りつぶしバッファ

    CTileImageA1    m_imgRes,
                    m_imgTmp;

    CTileImage  *m_pimgDst,     //!< 描画先
                *m_pimgRef;     //!< 判定元

    int         m_nType,        //!< タイプ
                m_nDiff,        //!< 許容する値の差
                m_nOpacity;     //!< 描画濃度

    RGBAFIX15   m_colDraw,
                m_colBegin;     //!< 開始点の色
    AXPoint     m_ptStart;      //!< 開始位置(px)
    FLAGRECT    m_rcfRef;       //!< 判定元範囲(px)

    BOOL (CDrawPaint::*m_funcComp)(int,int);

protected:
    void _getRefPoint(RGBAFIX15 *pdst,int x,int y);
    int _getRefAlpha(int x,int y);

    void _runNormal();
    void _run_scan(int lx,int rx,int y,int oy,PAINTBUF **pped);

    void _runAlphaAuto_horz();
    void _runAlphaAuto_vert();
    void _auto_scan_h(int lx,int rx,int y,int oy,PAINTBUF **pped);
    void _auto_scan_v(int ly,int ry,int x,int ox,PAINTBUF **pped);

    BOOL _compare_rgb(int x,int y);
    BOOL _compare_alpha(int x,int y);
    BOOL _compare_canvas(int x,int y);
    BOOL _compare_erase(int x,int y);

public:
    CDrawPaint();
    ~CDrawPaint();

    void free();
    int init(int type,int diff,int opacity,const RGBAFIX15 &colDraw,CTileImage *pDst,CTileImage *pRef,const AXPoint &ptStart);
    void run();
};

#endif
