/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_CUSTOMGRADSEL_H
#define _AZPT_CUSTOMGRADSEL_H

#include "AXWindow.h"
#include "AXImage.h"

class CGradListItem;
class AXString;

class CCustomGradSel:public AXWindow
{
protected:
    AXImage     m_img;

    CGradListItem   *m_pSel;

public:
    CCustomGradSel(AXWindow *pParent,UINT uItemID,int selno);

    CGradListItem *getSelItem() { return m_pSel; }

    void addNewGrad(const AXString *pstr=NULL);
    void copyGrad();
    void delGrad();
    void copyClipb();
    void pasteClipb();

    void draw();

    virtual BOOL onSize();
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

#endif

