/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    [CColorWin.cpp]
    CColorWin の各タブのウィジェット
*/

//--------- BASE

class CColWin_tabbase:public AXWindow
{
public:
    CColWin_tabbase(AXWindow *pParent);
    virtual void setColor(DWORD col);
    virtual void beforeRemoveTab();
};

//--------- BAR

class CColWin_bar:public CColWin_tabbase
{
protected:
    AXLabel         *m_plabel[3];
    CValBarSimple   *m_pbar[3];
    AXLineEdit      *m_pedit[3];
    AXCheckButton   *m_pckType[2];

    enum
    {
        ID_BAR1  = 100,
        ID_EDIT1 = 110,
        ID_RGB   = 120,
        ID_HSV
    };

    void _setColorType();
    void _setColorVal(DWORD col);
    void _changeVal();

public:
    CColWin_bar(AXWindow *pParent);

    virtual void setColor(DWORD col);
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//--------- HSV

class CColWin_hsv:public CColWin_tabbase
{
protected:
    CValBar     *m_pbar[3];
    AXHSVPicker *m_pPicker;

    enum
    {
        ID_BAR1 = 100
    };

    void _setColorBar(DWORD col);

public:
    CColWin_hsv(AXWindow *pParent);

    virtual void setColor(DWORD col);
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//--------- HLS

class CColWin_hls:public CColWin_tabbase
{
protected:
    CColSub_hlspal  *m_pPal;
    AXArrowButton   *m_pbtt;

    void _runMenu();

public:
    CColWin_hls(AXWindow *pParent);

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//--------- GRAD

class CColWin_grad:public CColWin_tabbase
{
protected:
    CColSub_grad *m_pGrad[CConfig::GRADPAL_NUM];

    enum { ID_GRAD1 = 100 };

public:
    CColWin_grad(AXWindow *pParent);

    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};

//--------- PAL

class CColWin_pal:public CColWin_tabbase
{
protected:
    CColSub_paltab  *m_pSel;
    CColSub_pal     *m_pPal;
    AXScrollBar     *m_pScr;
    AXArrowButton   *m_pbtt;

    void _runMenu();
    void _cmd_resize();
    void _cmd_load();
    void _cmd_save();
    void _cmd_createFromImg();
    void _cmd_displaySize();

public:
    CColWin_pal(AXWindow *pParent);

    virtual void beforeRemoveTab();
    virtual BOOL onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam);
};
