/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef _AZPT_BRUSHITEM_H_
#define _AZPT_BRUSHITEM_H_

#include "AXList.h"
#include "AXString.h"

class CBrushGroupItem;

class CBrushItem:public AXListItem
{
public:
    enum
    {
        WORDBASE_NUM    = 15,
        BYTEBASE_NUM    = 6,
        MINDATSIZE      = 3 + WORDBASE_NUM * 2 + BYTEBASE_NUM,

        RADIUS_MIN      = 3,
        RADIUS_MAX      = 6000,
        PRESS_MIN       = 1,
        PRESS_MAX       = 600,
        HOSEISTR_MAX    = 14,
        PIXTYPE_NUM     = 8,

        PIXTYPE_ERASE   = 3,
        PIXTYPE_BLUR    = 7
    };

    enum FLAGS
    {
        FLAG_MANUALSAVE = 1,
        FLAG_WATER      = 2,
        FLAG_IMGROT_DIR = 4,
        FLAG_ANTIALIAS  = 8,
        FLAG_CURVE      = 16
    };

public:
    CBrushGroupItem *pGroup;

    AXString    strName,
                strBrushImg,  //空:デフォルト
                strTexImg;    //空:なし（強制）、"?":オプション指定を使う

    WORD    wRadius,          //半径サイズ (1.0=10)
            wRadiusCtlMax,    //最大サイズ値
            wMinSize,         //最小サイズ(%) (1.0=10)
            wMinOpacity,      //最小濃度(%) (1.0=10)
            wInterval,        //間隔 (1.00=100)
            wRan_sizeMin,     //ランダム・サイズ最小 (1.0=10)
            wRan_posLen,      //ランダム・位置最大距離 (1.00=100)
            wWater[3],        //水彩
            wRotAngle,        //回転角度
            wRotRandom,       //回転ランダム
            wRoughness,       //荒さ
            wPressSize,       //筆圧・サイズ (1.00=100)
            wPressOpacity;    //筆圧・濃度 (1.00=100)
    BYTE    btOpacity,        //濃度 (0-100)
            btPixType,        //点の塗りタイプ
            btHoseiType,      //補正タイプ
            btHoseiStr,       //補正強さ(0-)
            btHardness,       //硬さ (0-100)
            btFlags;          //フラグ

public:
    CBrushItem *prev() { return (CBrushItem *)m_pPrev; }
    CBrushItem *next() { return (CBrushItem *)m_pNext; }

    BOOL isLinkSave() { return !(btFlags & FLAG_MANUALSAVE); }
    BOOL isManualSave() { return btFlags & FLAG_MANUALSAVE; }
    BOOL isWaterOn() { return btFlags & FLAG_WATER; }
    BOOL isBrushRotDir() { return btFlags & FLAG_IMGROT_DIR; }
    BOOL isAntiAlias() { return btFlags & FLAG_ANTIALIAS; }
    BOOL isCurve() { return btFlags & FLAG_CURVE; }

    void setDefault();
    void copyFrom(const CBrushItem *p);
    BOOL getTextFormat(AXString *pstr);
    BOOL paste(const AXString &strText);
};

#endif

