/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    フィルタ描画関数 - ほか2
*/

#include <math.h>

#include "CTileImage.h"
#include "CLayerList.h"
#include "CLayerItem.h"

#include "drawdat.h"
#include "global.h"

#include "filterdraw.h"
#include "filterdrawfunc.h"


namespace filterdraw
{

//! 1pxドット線の補正

BOOL dotthinning(FILTERDRAW &info)
{
    int x,y,i,j,pos,flag,n;
    BYTE c[25];
    CTileImage *pimg;
    RGBAFIX15 colZero,col;

    colZero.zero();

    pimg = info.pimgDst;

    info.progSetMax(50);

    //--------- phase1 (余分な点を消す)

    info.progBeginSub(25, info.rs.h);

    for(y = info.rs.y1; y <= info.rs.y2; y++)
    {
        for(x = info.rs.x1; x <= info.rs.x2; x++)
        {
            //透明なら処理なし

            if(pimg->isPixelTransparent(x, y)) continue;

            //3x3 範囲で色があるか

            for(i = -1, pos = 0; i <= 1; i++)
                for(j = -1; j <= 1; j++, pos++)
                    c[pos] = !pimg->isPixelTransparent(x + j, y + i);

            //上下が0と1か
            if((c[3] ^ c[5]) == 0) continue;
            //左右が0と1か
            if((c[1] ^ c[7]) == 0) continue;

            //

            flag = 0;
            n    = c[0] + c[2] + c[6] + c[8];

            if(n == 0)
                //斜めがすべて0
                flag = 1;
            else if(n == 1)
            {
                //斜めの1つが1で他3つが0の場合、斜めの点の左右・上下どちらかに点があるか

                if(c[0])
                    flag = c[1] ^ c[3];
                else if(c[2])
                    flag = c[1] ^ c[5];
                else if(c[6])
                    flag = c[3] ^ c[7];
                else
                    flag = c[5] ^ c[7];
            }

            //消す

            if(flag) pimg->setPixelDraw(x, y, colZero);
        }

        info.progIncSub();
    }

    //-------- phase2 (5x5 不自然な線の補正)

    info.progBeginSub(25, info.rs.h);

    for(y = info.rs.y1; y <= info.rs.y2; y++)
    {
        for(x = info.rs.x1; x <= info.rs.x2; x++)
        {
            //不透明なら処理なし

            if(!pimg->isPixelTransparent(x, y)) continue;

            //5x5 範囲の色

            for(i = -2, pos = 0; i <= 2; i++)
                for(j = -2; j <= 2; j++, pos++)
                    c[pos] = !pimg->isPixelTransparent(x + j, y + i);

            //3x3 内に点が4つか

            n = 0;

            for(i = 0, pos = 6; i < 3; i++, pos += 5 - 3)
                for(j = 0; j < 3; j++, pos++)
                    n += c[pos];

            if(n != 4) continue;

            //各判定

            if(c[6] + c[7] + c[13] + c[18] == 4)
            {
                if(c[1] + c[2] + c[3] + c[9] + c[14] + c[19] == 0)
                {
                    pimg->getPixel(&col, x + 1, y);

                    pimg->setPixelDraw(x, y, col);
                    pimg->setPixelDraw(x + 1, y, colZero);
                    pimg->setPixelDraw(x, y - 1, colZero);
                }
            }
            else if(c[8] + c[13] + c[16] + c[17] == 4)
            {
                if(c[9] + c[14] + c[19] + c[21] + c[22] + c[23] == 0)
                {
                    pimg->getPixel(&col, x + 1, y);

                    pimg->setPixelDraw(x, y, col);
                    pimg->setPixelDraw(x + 1, y, colZero);
                    pimg->setPixelDraw(x, y + 1, colZero);
                }
            }
            else if(c[7] + c[8] + c[11] + c[16] == 4)
            {
                if(c[1] + c[2] + c[3] + c[5] + c[10] + c[15]  == 0)
                {
                    pimg->getPixel(&col, x - 1, y);

                    pimg->setPixelDraw(x, y, col);
                    pimg->setPixelDraw(x - 1, y, colZero);
                    pimg->setPixelDraw(x, y - 1, colZero);
                }
            }
            else if(c[6] + c[11] + c[17] + c[18] == 4)
            {
                if(c[5] + c[10] + c[15] + c[21] + c[22] + c[23] == 0)
                {
                    pimg->getPixel(&col, x - 1, y);

                    pimg->setPixelDraw(x, y, col);
                    pimg->setPixelDraw(x - 1, y, colZero);
                    pimg->setPixelDraw(x, y + 1, colZero);
                }
            }
        }

        info.progIncSub();
    }

    return TRUE;
}

//! 縁取り

BOOL hemming(FILTERDRAW &info)
{
    CTileImage *pimgTmp1=NULL,*pimgTmp2=NULL,*pimgRef,*pimg;
    CLayerItem *pitem;
    int i,x,y;
    RGBAFIX15 col,colDraw;
    TILEIMGPIXFUNC funcPix;

    //

    i = info.valbar[0] * 20;
    if(info.valcheck[1]) i += 20;

    info.progSetMax(i);

    getDrawColor(&colDraw, info.valcombo[0]);

    //作業用イメージ

    pimgTmp1 = allocTmpImage(info, info.rs);
    pimgTmp2 = allocTmpImage(info, info.rs);

    if(!pimgTmp1 || !pimgTmp2) goto ERR;

    //判定元イメージ

    pimgRef = NULL;

    if(info.valcheck[0])
    {
        //チェックレイヤ

        pitem = g_draw->player->setLinkCheck();
        if(pitem) pimgRef = pitem->m_pimg;
    }

    if(!pimgRef) pimgRef = info.pimgSrc;

    //準備

    CTileImage::m_pinfo->funcColor = &CTileImage::colfunc_normal;

    if(info.isPrev())
    {
        funcPix = &CTileImage::setPixel_colfunc;

        copyRect(info);
    }
    else
        funcPix = &CTileImage::setPixelDraw;

    //-------- 縁取り描画 (tmp1 を参照として、dst と tmp2 へ描画)

    pimg = info.pimgDst;

    if(!pimgTmp2->copy(*pimgRef)) goto ERR;

    for(i = info.valbar[0]; i > 0; i--)
    {
        //tmp2 を tmp1 にコピー

        if(!pimgTmp1->copy(*pimgTmp2)) goto ERR;

        //tmp1 を判定元として、その点を上下左右に合成

        info.progBeginSub(20, info.rs.h);

        for(y = info.rs.y1; y <= info.rs.y2; y++)
        {
            for(x = info.rs.x1; x <= info.rs.x2; x++)
            {
                pimgTmp1->getPixel(&col, x, y);
                if(!col.a) continue;

                colDraw.a = col.a;

                //dst 描画

                (pimg->*funcPix)(x - 1, y, colDraw);
                (pimg->*funcPix)(x + 1, y, colDraw);
                (pimg->*funcPix)(x, y - 1, colDraw);
                (pimg->*funcPix)(x, y + 1, colDraw);

                //次の判定用に tmp2 に描画
                //（tmp1 に描画すると判定用として使えないため）

                pimgTmp2->setPixel_colfunc(x - 1, y, colDraw);
                pimgTmp2->setPixel_colfunc(x + 1, y, colDraw);
                pimgTmp2->setPixel_colfunc(x, y - 1, colDraw);
                pimgTmp2->setPixel_colfunc(x, y + 1, colDraw);
            }

            info.progIncSub();
        }
    }

    delete pimgTmp1;
    delete pimgTmp2;

    //-------- 判定元画像を切り抜く

    if(info.valcheck[1])
    {
        CTileImage::m_pinfo->funcColor = &CTileImage::colfunc_erase;

        info.progBeginSub(20, info.rs.h);

        for(y = info.rs.y1; y <= info.rs.y2; y++)
        {
            for(x = info.rs.x1; x <= info.rs.x2; x++)
            {
                pimgRef->getPixel(&col, x, y);

                if(col.a)
                    (pimg->*funcPix)(x, y, col);
            }

            info.progIncSub();
        }
    }

    return TRUE;

ERR:
    if(pimgTmp1) delete pimgTmp1;
    if(pimgTmp2) delete pimgTmp2;

    return FALSE;
}

};
