/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    カーソル関連
*/

#include "cursor.h"

#include "AXCursor.h"

#include "cursorimg.h"


namespace cursor
{

//! カーソルデータのポインタ取得

const unsigned char *getImgDat(int type)
{
    const unsigned char *p[] = {
        g_cursor_draw, g_cursor_hand, g_cursor_handdrag, g_cursor_loupe,
        g_cursor_move, g_cursor_rotate, g_cursor_sel,
        g_cursor_boxedit, g_cursor_spoit, g_cursor_text,
        g_cursor_wait, g_cursor_seldrag, g_cursor_itemmove
    };

    return p[type];
}

//! カーソル作成

void create(AXCursor *pcur,int type)
{
    pcur->create(getImgDat(type));
}

};
