/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CUndo - アンドゥ管理クラス
*/


#include "CUndo.h"

#include "CUndoDat.h"
#include "CLayerItem.h"
#include "CTileImage.h"

#include "drawdat.h"
#include "global.h"



CUndo::CUndo()
{
    m_bChange = FALSE;
}

//! データ作成

AXUndoDat *CUndo::createDat()
{
    return new CUndoDat(0);
}

//! アンドゥデータ追加後

void CUndo::afterAddUndo()
{
    m_bChange = TRUE;
}

//! アンドゥデータ追加

CUndoDat *CUndo::_addundo(int cmd)
{
    CUndoDat *p;

    addDat(p = new CUndoDat(cmd));

    return p;
}


//=========================


//! カレントレイヤのUNDO用イメージ
/*!
    @param info  描画前の画像情報
    @param rcs   更新範囲(キャンバス範囲内。x==-1 でUNDOイメージはあるがキャンバス範囲外)
*/

void CUndo::add_curLayerUndoImage(const TILEIMGINFO &info,const AXRectSize &rcs)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_UNDOIMG);

    p->setval_curlayer();
    p->m_nVal[1] = rcs.x;
    p->m_nVal[2] = rcs.y;
    p->m_nVal[3] = rcs.w;
    p->m_nVal[4] = rcs.h;

    p->writeUndoImage(info);

/*
    CUndoDat *p;
    BOOL bSmall;

    //タイル配列に変化がなく、キャンバス範囲内で、範囲が 64x64 以内なら少範囲用

    bSmall = (g_draw->pcurlayer->m_pimg->isSameArraySize(info) &&
        rcs.x != -1 && rcs.w * rcs.h <= 64 * 64);

    p = _addundo((bSmall)? CUndoDat::CMD_UNDOIMG_SMALL: CUndoDat::CMD_UNDOIMG);

    p->setval_curlayer();
    p->m_nVal[1] = rcs.x;
    p->m_nVal[2] = rcs.y;
    p->m_nVal[3] = rcs.w;
    p->m_nVal[4] = rcs.h;

    if(bSmall)
        p->writeImageSmall(g_draw->pimgUndo, TRUE);
    else
        p->writeUndoImage(info);
*/
}

//! レイヤ追加時（追加後）
/*
    [0] 追加後の親レイヤ位置
    [1] 追加後の子レイヤ番号
*/

void CUndo::add_layerNew()
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_NEW);

    p->setval_layerno_parent(0, g_draw->pcurlayer);
}

//! レイヤ複製時

void CUndo::add_layerCopy()
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_COPY);

    p->setval_curlayer();
}

//! レイヤ削除

void CUndo::add_layerDel()
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_DEL);

    p->setval_curlayer();

    p->writeLayerFolder(g_draw->pcurlayer);
}

//! レイヤクリア

void CUndo::add_layerClear()
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_CLEAR);

    p->setval_curlayer();

    p->writeLayerOnlyImage(g_draw->pcurlayer);
}

//! レイヤ・カラータイプ変更
/*
    [0] レイヤ番号
    [1] 元のカラータイプ
    [2] 変換後のカラータイプ
    [3] 輝度から変換か
*/

void CUndo::add_layerColType(CLayerItem *pItem,int coltype,BOOL bLum)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_COLTYPE);

    p->setval_layerno(0, pItem);
    p->m_nVal[1] = pItem->m_nColType;
    p->m_nVal[2] = coltype;
    p->m_nVal[3] = bLum;

    p->writeLayerOnlyImage(pItem);
}

//! レイヤ下に移す/結合

void CUndo::add_layerCombine(BOOL bDrop)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_COMBINE);

    p->m_nVal[0] = bDrop;
    p->setval_layerno_parent(1, g_draw->pcurlayer);

    if(bDrop)
        p->writeLayerTwoImage(g_draw->pcurlayer);
    else
        p->writeLayerCombine(TRUE);
}

//! 複数レイヤ結合
/*
    [0] タイプ (0:フォルダ, 1:すべて)
    [1] フォルダ時、親レイヤ番号
    [2] フォルダ時、子レイヤ番号
*/

void CUndo::add_layerCombineMul(int type)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_COMBINEMUL);

    p->m_nVal[0] = type;
    p->setval_layerno_parent(1, g_draw->pcurlayer);

    if(type == 0)
        p->writeLayerFolder(g_draw->pcurlayer);
    else
        p->writeLayerAll();
}

//! レイヤ・一覧上位置の移動時 (移動後)
/*
    [0] 移動後の親レイヤ番号
    [1] 移動前後のフォルダ内位置番号
    [2] 移動前の親レイヤ番号
    [3] 移動前のフォルダ内位置番号
*/

void CUndo::add_layerMove(CLayerItem *pItem,int *bkno)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_MOVE);

    p->setval_layerno_parent(0, pItem);

    p->m_nVal[2] = bkno[0];
    p->m_nVal[3] = bkno[1];
}

//! レイヤ左右/上下反転
/*
    [0] レイヤ番号
    [1] 0 以外で左右、0 で上下
*/

void CUndo::add_layerHVRev(BOOL bHorz)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_HVREV);

    p->setval_curlayer();
    p->m_nVal[1] = bHorz;
}

//! レイヤ90度回転
/*
    [0] レイヤ番号
    [1] 0 以外で左、0 で右
*/

void CUndo::add_layerRotate90(BOOL bLeft)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_ROTATE90);

    p->setval_curlayer();
    p->m_nVal[1] = !bLeft;
}

//! レイヤのフラグ情報
/*
    [0] レイヤ番号
    [1] フラグ (ビットがONで変更されたフラグ)
*/

void CUndo::add_layerFlags(CLayerItem *pItem,DWORD dwFlag)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_FLAGS);

    p->setval_layerno(0, pItem);
    p->m_nVal[1] = dwFlag;
}

//! レイヤオフセット位置移動
/*
    [0] movx
    [1] movy
    [2] レイヤ数
    [3] レイヤ数が1の場合、レイヤ番号
*/

void CUndo::add_layerOffset(int movx,int movy,CLayerItem *pTop,int linkcnt)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_LAYER_OFFSET);

    p->m_nVal[0] = -movx;
    p->m_nVal[1] = -movy;
    p->m_nVal[2] = linkcnt;

    if(linkcnt == 1)
        p->setval_curlayer(3);
    else
        p->writeLinkLayersNO(pTop, linkcnt);
}

//! キャンバスサイズ変更

void CUndo::add_resizeCanvas(int addx,int addy,int imgw,int imgh)
{
    CUndoDat *p = _addundo(CUndoDat::CMD_CANVAS_RESIZE);

    p->m_nVal[0] = -addx;
    p->m_nVal[1] = -addy;
    p->m_nVal[2] = imgw;
    p->m_nVal[3] = imgh;
}

//! キャンバス拡大縮小

void CUndo::add_scaleCanvas()
{
    CUndoDat *p = _addundo(CUndoDat::CMD_CANVAS_SCALE);

    p->m_nVal[0] = g_draw->nImgW;
    p->m_nVal[1] = g_draw->nImgH;
    p->m_nVal[2] = g_draw->nImgDPI;

    p->writeLayerAll();
}
