/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CResource - フォントや画像などのリソースデータ
*/

#include "CResource.h"

#include "CConfig.h"
#include "global.h"

#include "AXImageList.h"
#include "AXImage32.h"
#include "AXFont.h"
#include "AXTarBall.h"
#include "AXUtilRes.h"
#include "AXApp.h"



CResource::~CResource()
{
    if(pfontMain) delete pfontMain;
    if(pfontSubWin) delete pfontSubWin;
    delete pfontSmall;

    delete pilMainTB;
    delete pilToolTB;
    delete pilToolSubTB;
    delete pilLayerTB;

    delete pimgRule;
    delete pimgAMask;
}

// ※設定読み込みより後、ウィンドウ作成より前に実行する

CResource::CResource()
{
    AXTarBall tar;
    AXString str;

    pfontMain   = NULL;
    pfontSubWin = NULL;

    //------- 作成

    pilMainTB    = new AXImageList;
    pilToolTB    = new AXImageList;
    pilToolSubTB = new AXImageList;
    pilLayerTB   = new AXImageList;

    pimgRule    = new AXImage32;
    pimgAMask   = new AXImage32;

    //------- フォント

    if(g_conf->strFontWin.isNoEmpty())
    {
        pfontMain   = new AXFont;
        pfontSubWin = new AXFont;

        pfontMain->createStyleSize(g_conf->strFontWin, g_conf->sFontSizeDef);
        pfontSubWin->createStyleSize(g_conf->strFontWin, g_conf->sFontSizeSubWin);
    }

    //11px

    pfontSmall = new AXFont;

    if(g_conf->strFontWin.isEmpty())
        pfontSmall->createAppFontPxSize(11);
    else
        pfontSmall->createStyleSize(g_conf->strFontWin, -11);

    //------- tar内画像

    axapp->getResourcePath(&str, "images.tar");

    tar.loadFile(str);

    //

    AXLoadTarResImageList(&tar, pilMainTB, "tb_main.png", 16, 0x00ff00, FALSE);
    AXLoadTarResImageList(&tar, pilToolTB, "tb_tool.png", 16, 0x00ff00, FALSE);
    AXLoadTarResImageList(&tar, pilToolSubTB, "tb_toolsub.png", 16, 0x00ff00, FALSE);
    AXLoadTarResImageList(&tar, pilLayerTB, "tb_layer.png", 12, 0x00ff00, FALSE);

    AXLoadTarResImage32(&tar, pimgRule, "img_rule.png");
    AXLoadTarResImage32(&tar, pimgAMask, "img_amask.png");

/*
    //ファイルから直接読み込み

    AXLoadResImageList(pilMainTB, "tb_main.png", 16, 0x00ff00, FALSE);
    AXLoadResImageList(pilToolTB, "tb_tool.png", 16, 0x00ff00, FALSE);
    AXLoadResImageList(pilToolSubTB, "tb_toolsub.png", 16, 0x00ff00, FALSE);
    AXLoadResImageList(pilLayerTB, "tb_layer.png", 12, 0x00ff00, FALSE);

    AXLoadResImage32(pimgRule, "img_rule.png");
    AXLoadResImage32(pimgAMask, "img_amask.png");
*/
}

//! 定規イメージ選択描画

void CResource::drawRuleImgSel(int no)
{
    int h;

    h = pimgRule->getHeight();

    //黒以外を白にする

    pimgRule->replaceExtract(0, 0, pimgRule->getWidth(), h, 0xffffff, 0);

    //選択部分の黒以外を選択色へ

    pimgRule->replaceExtract(no * (h - 1) + 1, 1, h - 2, h - 2, 0xffa0a0, 0);
}
