/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CPerlinNoise - Perlin Noise 生成クラス
*/


#include <string.h>
#include <math.h>

#include "CPerlinNoise.h"

#include "AXRand.h"


//! 初期化

BOOL CPerlinNoise::init(AXRand *prand,double freq,double persis)
{
    int i,no;
    BYTE n;
    LPBYTE p;

    m_freq   = freq;
    m_persis = persis;

    //--------

    if(!m_mem.alloc(512)) return FALSE;

    p = m_mem;

    for(i = 0; i < 256; i++)
        p[i] = i;

    //入れ替え

    for(i = 0; i < 256; i++)
    {
        no = prand->getDWORD() & 255;

        n     = p[i];
        p[i]  = p[no];
        p[no] = n;
    }

    ::memcpy(p + 256, p, 256);

    return TRUE;
}

//! 値取得

double CPerlinNoise::noise(double x,double y)
{
    double total,amp;
    int i;

    total = 0;
    amp   = m_persis;

    x *= m_freq;
    y *= m_freq;

    for(i = 0; i < 8; i++)
    {
        total += _noise(x, y) * amp;

        x *= 2;
        y *= 2;
        amp *= m_persis;
    }

    return total;
}

//! 計算

double CPerlinNoise::_noise(double x,double y)
{
    double fx,fy,u,v,d1,d2;
    int nx,ny,a,aa,ab,b,ba,bb;
    LPBYTE p = m_mem;

    fx = ::floor(x);
    fy = ::floor(y);

    nx = ((int)fx) & 255;
    ny = ((int)fy) & 255;

    x -= fx;
    y -= fy;

    u = x * x * (3 - 2 * x);
    v = y * y * (3 - 2 * y);

    a  = p[nx] + ny;
    aa = p[a];
    ab = p[a + 1];
    b  = p[nx + 1] + ny;
    ba = p[b];
    bb = p[b + 1];

    //

    d1 = _lerp(u, _grad(p[aa], x, y), _grad(p[ba], x - 1, y));
    d2 = _lerp(u, _grad(p[ab], x, y - 1), _grad(p[bb], x - 1, y - 1));

    return _lerp(v, d1, d2);
}

double CPerlinNoise::_lerp(double t,double a,double b)
{
    return a + t * (b - a);
}

double CPerlinNoise::_grad(int hash,double x,double y)
{
    int h = hash & 15;
    double u,v;

    u = (h < 8)? x: y;
    v = (h < 4)? y: ((h == 12 || h == 14)? x: 0);

    return ((h & 1) == 0? u: -u) + ((h & 2) == 0? v: -v);
}
