/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CKeyDat - キー設定データ

    データが変更された時のみ保存する。
*/

#include "CKeyDat.h"

#include "AXFile.h"


CKeyDat *CKeyDat::m_pSelf = NULL;


CKeyDat::~CKeyDat()
{
    AXFree((void **)&m_pBuf);
}

CKeyDat::CKeyDat()
{
    m_pSelf = this;

    m_pBuf    = NULL;
    m_nCnt    = 0;
    m_bChange = FALSE;
}

//! メモリ確保

BOOL CKeyDat::alloc(int cnt)
{
    //解放

    AXFree((void **)&m_pBuf);
    m_nCnt = 0;

    //

    if(cnt == 0) return FALSE;

    //確保

    m_pBuf = (LPDWORD)AXMalloc(cnt * sizeof(DWORD));
    if(!m_pBuf) return FALSE;

    m_nCnt    = cnt;
    m_bChange = TRUE;

    return TRUE;
}

//! コマンドIDからキー取得
/*!
    @return 0 で見つからなかった
*/

int CKeyDat::getKey(int id)
{
    LPDWORD p = m_pBuf;
    int i;

    for(i = m_nCnt; i > 0; i--, p++)
    {
        if((int)(*p >> 16) == id)
            return *p & 0xffff;
    }

    return 0;
}

//! キーからコマンドID取得
/*!
    @return -1 で見つからなかった
*/

int CKeyDat::getCmd(UINT key)
{
    LPDWORD p = m_pBuf;
    int i;

    for(i = m_nCnt; i > 0; i--, p++)
    {
        if((int)(*p & 0xffff) == key)
            return *p >> 16;
    }

    return -1;
}

//! キー＋操作時の検索用、キーからコマンドID取得

int CKeyDat::getCmdDraw(UINT key)
{
    LPDWORD p = m_pBuf;
    int i,cmd;

    for(i = m_nCnt; i > 0; i--, p++)
    {
        cmd = *p >> 16;

        /* キー＋操作は 2000 〜 2999 の範囲。
           この範囲はデータの先頭にあるので、この範囲以外のコマンドIDが来れば終了 */

        if(cmd < 2000 || cmd >= 3000)
            return -1;

        if((*p & 0xffff) == key)
            return cmd;
    }

    return -1;
}


//============================
// ファイル
//============================


//! 保存

void CKeyDat::saveFile(const AXString &filename)
{
    AXFile file;

    //データの変更なし

    if(!m_bChange) return;

    //---------

    if(!file.openWrite(filename)) return;

    //ヘッダ
    file.writeStr("AZPTLKEY");
    //バージョン
    file.writeBYTE(0);

    //キー数

    file.writeWORD(m_nCnt);

    //キーデータ

    file.write(m_pBuf, sizeof(DWORD) * m_nCnt);

    file.close();
}

//! 読み込み

void CKeyDat::loadFile(const AXString &filename)
{
    AXFile file;
    BYTE ver;
    WORD cnt;

    if(!file.openRead(filename)) return;

    //ヘッダ

    if(!file.readCompare("AZPTLKEY")) return;

    //バージョン

    file.read(&ver, 1);
    if(ver != 0) return;

    //キー数

    file.readWORD(&cnt);

    //確保

    if(!alloc(cnt)) return;

    m_bChange = FALSE;

    //キーデータ

    file.read(m_pBuf, m_nCnt * sizeof(DWORD));

    file.close();
}
