/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CBrushSizeList - ブラシサイズのリストデータ
*/


#include "CBrushSizeList.h"

#include "AXString.h"
#include "AXUtilStr.h"


CBrushSizeList *CBrushSizeList::m_pSelf = NULL;


CBrushSizeList::CBrushSizeList()
{
    m_pSelf = this;

    m_nCnt = 0;

    m_memBuf.alloc(sizeof(WORD) * 10, sizeof(WORD) * 10);
}

//! 確保(読み込み時用)

void CBrushSizeList::alloc(int cnt)
{
    if(cnt < 10) cnt = 10;

    m_memBuf.alloc(sizeof(WORD) * cnt, sizeof(WORD) * 10);
}

//! データ追加

void CBrushSizeList::addSize(int size)
{
    if(m_memBuf.addWORD(size))
        m_nCnt++;
}

//! 文字列からデータ追加('/'で区切って複数)

void CBrushSizeList::addFromText(AXString *pstr)
{
    LPUSTR pc;
    int val,n,i,pos;
    LPWORD p;

    *pstr += '/';
    pstr->replace('/', 0);

    for(pc = *pstr; *pc; pc += AXUStrLen(pc) + 1)
    {
        //値取得

        val = (int)(AXUStrToDouble(pc) * 10 + 0.5);

        if(val < MINVAL) val = MINVAL;
        else if(val > MAXVAL) val = MAXVAL;

        //挿入位置（値の小さい順）
        //※同じ値がある場合は追加しない

        p   = m_memBuf;
        pos = m_nCnt;       //値が一番大きい場合をデフォルトとする

        for(i = 0; i < m_nCnt; i++)
        {
            n = *(p++);

            if(n == val) { pos = -1; break; }
            if(n > val) { pos = i; break; }
        }

        if(pos == -1) continue; //同じ値があった場合

        if(m_nCnt >= MAXCNT) return;

        //データ追加（仮）

        if(!m_memBuf.addWORD(0)) return;

        //挿入位置を空けてセット

        p = m_memBuf;

        for(i = m_nCnt; i > pos; i--)
            p[i] = p[i - 1];

        p[pos] = val;

        m_nCnt++;
    }
}

//! 指定位置のデータ削除

void CBrushSizeList::del(int no)
{
    LPWORD p;
    int i;

    p = m_memBuf;

    for(i = no; i < m_nCnt - 1; i++)
        p[i] = p[i + 1];

    //

    m_nCnt--;

    m_memBuf.setNowSize(m_nCnt * sizeof(WORD));
}
