/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CBrushItemImgList - ブラシ・テクスチャ画像管理のリストクラス

    最近使われたものを常に5個ストックしておく。
*/


#include "CBrushItemImgList.h"

#include "CImage8.h"
#include "CImage32.h"
#include "CConfig.h"

#include "global.h"

#include "AXApp.h"



//*************************************
// CBrushItemImgList
//*************************************


//! 画像読み込み
/*!
    すでにリスト上にあるものはそのままポインタを返す。@n
    リスト上にない場合は読み込んで作成する。

    @return NULL でなし
*/

CImage8 *CBrushItemImgList::getImage(int type,const AXString &strPath)
{
    CBrushImgItem *p;
    CImage8 *pimg;
    AXList *plist;

    //なし
    if(strPath.isEmpty()) return NULL;
    //オプション指定を使う
    if(strPath == "?") return NULL;

    //同じ画像があるか

    p = _searchImage(type, strPath);

    plist = m_list + type;

    if(p)
    {
        //アイテムを先頭へ移動

        plist->moveTop(p);
    }
    else
    {
        //--------- 新規追加

        //イメージ作成

        pimg = _loadImage(type, strPath);
        if(!pimg) return NULL;

        //古いのを削除

        if(plist->getCnt() >= 5)
            plist->deleteItem(plist->getBottom());

        //アイテム追加（先頭に）

        p = new CBrushImgItem;

        p->m_pimg    = pimg;
        p->m_strPath = strPath;

        plist->add(p);
        plist->moveTop(p);
    }

    return p->m_pimg;
}

//! 画像作成＆読み込み

CImage8 *CBrushItemImgList::_loadImage(int type,const AXString &strPath)
{
    CImage32 img32;
    CImage8 *pimg8;
    AXString str;
    CImage32::LOADINFO info;
    BOOL ret;

    //パス

    if(strPath[0] == '/')
    {
        //システム

        if(type == TYPE_BRUSH)
            axapp->getResourcePath(&str, "brush");
        else
            axapp->getResourcePath(&str, "texture");

        str.path_add(strPath.at(1));
    }
    else
    {
        //ユーザー

        if(type == TYPE_BRUSH)
            str = g_conf->strUserBrushDir;
        else
            str = g_conf->strUserTexDir;

        str.path_add(strPath);
    }

    //32bit読み込み

    if(!img32.loadImage(str, &info))
        return NULL;

    //8bit作成＆変換

    pimg8 = new CImage8;

    if(type == TYPE_BRUSH)
        ret = pimg8->createFrom32bit_brush(img32, info.bAlpha);
    else
        ret = pimg8->createFrom32bit(img32, info.bAlpha);

    if(!ret)
    {
        delete pimg8;
        return NULL;
    }

    return pimg8;
}

//! パス名から画像検索

CBrushImgItem *CBrushItemImgList::_searchImage(int type,const AXString &strPath)
{
    CBrushImgItem *p;

    p = (CBrushImgItem *)m_list[type].getTop();

    for(; p; p = p->next())
    {
        if(p->m_strPath == strPath)
            return p;
    }

    return NULL;
}



//***********************************
// CBrushImgItem
//***********************************


CBrushImgItem::CBrushImgItem()
{
    m_pimg = NULL;
}

CBrushImgItem::~CBrushImgItem()
{
    if(m_pimg) delete m_pimg;
}
