/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    CBrushItem - ブラシの個々のデータ
*/

#include <string.h>
#include <stdlib.h>

#include "CBrushItem.h"

#include "AXByteString.h"
#include "AXMem.h"
#include "AXBuf.h"
#include "AXUtil.h"
#include "AXUtilStr.h"


//! デフォルトデータセット

void CBrushItem::setDefault()
{
    strName   = "new";
    strTexImg = '?';

    wRadius         = 40;
    wRadiusCtlMax   = 1000;
    wMinSize        = 0;
    wMinOpacity     = 1000;
    wInterval       = 20;
    wRan_sizeMin    = 1000;
    wRan_posLen     = 0;
    wWater[0]       = 400;
    wWater[1]       = 600;
    wWater[2]       = 300;
    wRotAngle       = 0;
    wRotRandom      = 0;
    wRoughness      = 0;
    wPressSize      = 100;
    wPressOpacity   = 100;

    btOpacity       = 100;
    btPixType       = 0;
    btHoseiType     = 3;
    btHoseiStr      = 0;
    btHardness      = 100;
    btFlags         = FLAG_ANTIALIAS;
}

//! データコピー

void CBrushItem::copyFrom(const CBrushItem *p)
{
    strName         = p->strName;
    strBrushImg     = p->strBrushImg;
    strTexImg       = p->strTexImg;

    wRadius         = p->wRadius;
    wRadiusCtlMax   = p->wRadiusCtlMax;
    wMinSize        = p->wMinSize;
    wMinOpacity     = p->wMinOpacity;
    wInterval       = p->wInterval;
    wRan_sizeMin    = p->wRan_sizeMin;
    wRan_posLen     = p->wRan_posLen;
    wWater[0]       = p->wWater[0];
    wWater[1]       = p->wWater[1];
    wWater[2]       = p->wWater[2];
    wRotAngle       = p->wRotAngle;
    wRotRandom      = p->wRotRandom;
    wRoughness      = p->wRoughness;
    wPressSize      = p->wPressSize;
    wPressOpacity   = p->wPressOpacity;

    btOpacity       = p->btOpacity;
    btPixType       = p->btPixType;
    btHoseiType     = p->btHoseiType;
    btHoseiStr      = p->btHoseiStr;
    btHardness      = p->btHardness;
    btFlags         = p->btFlags;
}

//! コピー用、テキストフォーマットで取得

BOOL CBrushItem::getTextFormat(AXString *pstr)
{
    AXMem mem,memDst;
    AXBuf buf;
    AXByteString strbName,strbBrush,strbTex;
    int size,sizeDst,i;
    LPWORD pwd;

    //文字列をUTF8へ

    strName.toUTF8(&strbName);
    strBrushImg.toUTF8(&strbBrush);
    strTexImg.toUTF8(&strbTex);

    //データサイズ

    size = strbName.getLen() + 1;
    size += strbBrush.getLen() + 1;
    size += strbTex.getLen() + 1;
    size += sizeof(WORD) * WORDBASE_NUM + BYTEBASE_NUM;

    //確保

    if(!mem.alloc(size)) return FALSE;

    sizeDst = AXGetBase64EncSize(size);

    if(!memDst.alloc(sizeDst)) return FALSE;

    //----------- データをビッグエンディアンでセット

    buf.init(mem, size, AXBuf::ENDIAN_BIG);

    //文字列（NULL 文字含む UTF8）

    buf.setDat((LPSTR)strbName, strbName.getLen() + 1);
    buf.setDat((LPSTR)strbBrush, strbBrush.getLen() + 1);
    buf.setDat((LPSTR)strbTex, strbTex.getLen() + 1);

    //WORDデータ

    pwd = &wRadius;

    for(i = 0; i < WORDBASE_NUM; i++, pwd++)
        buf.setWORD(pwd);

    //BYTEデータ

    buf.setDat(&btOpacity, BYTEBASE_NUM);

    //---------- テキストセット

    *pstr = "AZPTLBR:";
    *pstr += size;
    *pstr += ':';

    AXEncodeBase64(memDst, mem, size);

    pstr->appendAscii(memDst, sizeDst);

    return TRUE;
}

//! テキストフォーマットから貼り付け

BOOL CBrushItem::paste(const AXString &strText)
{
    AXByteString strb;
    AXMem memDat;
    LPSTR pc;
    LPWORD pwd;
    LPBYTE pbt;
    int srcsize,decsize,len,i;

    strText.toAscii(&strb);

    pc = strb;

    //ヘッダ

    if(::strncmp(pc, "AZPTLBR:", 8) != 0) return FALSE;
    pc += 8;

    //ソースサイズ

    srcsize = ::atoi(pc);
    if(srcsize < MINDATSIZE) return FALSE;

    for(; *pc && *pc != ':'; pc++);

    if(!*pc) return FALSE;
    pc++;

    //データ

    if(!memDat.alloc(srcsize)) return FALSE;

    decsize = AXDecodeBase64(memDat, pc, srcsize);
    if(decsize != srcsize) return FALSE;

    //------- バッファから変換

    //名前

    pc  = (LPSTR)memDat;
    len = ::strlen(pc);

    strName.setUTF8(pc, len);

    pc += len + 1;

    //ブラシ画像

    len = ::strlen(pc);
    strBrushImg.setUTF8(pc, len);
    pc += len + 1;

    //テクスチャ画像

    len = ::strlen(pc);
    strTexImg.setUTF8(pc, len);
    pc += len + 1;

    //WORDデータ

    pwd = &wRadius;
    pbt = (LPBYTE)pc;

    for(i = 0; i < WORDBASE_NUM; i++, pbt += 2)
        *(pwd++) = (pbt[0] << 8) | pbt[1];

    //BYTEデータ

    ::memcpy(&btOpacity, pbt, BYTEBASE_NUM);

    return TRUE;
}
