/*****************************************************************************
 *  Copyright (C) 2012-2015 Azel.
 *
 *  This file is part of AzXClass.
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
******************************************************************************/

#ifndef _AX_EXPANDER_H_
#define _AX_EXPANDER_H_

#include "AXWindow.h"
#include "AXString.h"
#include "AXRect.h"

class AXExpander:public AXWindow
{
public:
    enum
    {
        EXPS_BORDER_TOP  = WS_EXTRA,
        EXPS_HEADER_DARK = WS_EXTRA<<1,

        EXPN_TOGGLE = 0
    };

protected:
    AXString    m_strText;
    AXRect      m_rcPadding;
    BOOL        m_bExpand;
    int         m_nHeaderH;

    void _createExpander();
    void _changeExpand();

public:
    virtual ~AXExpander();

    AXExpander(AXWindow *pParent,UINT uStyle,UINT uLayoutFlags);
    AXExpander(AXWindow *pParent,UINT uStyle,UINT uLayoutFlags,UINT uItemID,DWORD dwPadding);
    AXExpander(AXWindow *pParent,UINT uStyle,UINT uLayoutFlags,UINT uItemID,DWORD dwPadding,LPCUSTR pstr);
    AXExpander(AXWindow *pParent,UINT uStyle,UINT uLayoutFlags,UINT uItemID,DWORD dwPadding,WORD wStrID);

    BOOL isExpand() { return (m_bExpand != 0) ; }
    void setText(const AXString &str);
    void setInsidePadding(int left,int top,int right,int bottom);
    void expand(BOOL bExpand);

    virtual void calcDefSize();
    virtual void getClientRect(AXRect *prc);
    virtual BOOL onPaint(AXHD_PAINT *phd);
    virtual BOOL onButtonDown(AXHD_MOUSE *phd);
};

#endif
