/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;

public class SdkUtils {
    private static String sLineSeparator;
    public static final String FILENAME_PREFIX = "From: ";

    public static boolean endsWithIgnoreCase(@NonNull String string, @NonNull String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(@NonNull CharSequence sequence, @NonNull CharSequence suffix) {
        return SdkUtils.endsWith(sequence, sequence.length(), suffix);
    }

    public static boolean endsWith(@NonNull CharSequence sequence, int endOffset, @NonNull CharSequence suffix) {
        if (endOffset < suffix.length()) {
            return false;
        }
        int i = endOffset - 1;
        for (int j = suffix.length() - 1; j >= 0; --j) {
            if (sequence.charAt(i) != suffix.charAt(j)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(@NonNull String string, @NonNull String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWith(@NonNull String string, int offset, @NonNull String prefix) {
        return string.regionMatches(true, offset, prefix, 0, prefix.length());
    }

    public static String stripWhitespace(@NonNull String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean hasUpperCaseCharacter(@NonNull String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static String getLineSeparator() {
        if (sLineSeparator == null) {
            sLineSeparator = System.getProperty("line.separator");
        }
        return sLineSeparator;
    }

    @NonNull
    public static String wrap(@NonNull String text, int lineWidth, @Nullable String hangingIndent) {
        if (hangingIndent == null) {
            hangingIndent = "";
        }
        int explanationLength = text.length();
        StringBuilder sb = new StringBuilder(explanationLength * 2);
        int index = 0;
        while (index < explanationLength) {
            int next;
            int lineEnd = text.indexOf(10, index);
            if (lineEnd != -1 && lineEnd - index < lineWidth) {
                next = lineEnd + 1;
            } else {
                lineEnd = Math.min(index + lineWidth, explanationLength);
                if (lineEnd - index < lineWidth) {
                    next = explanationLength;
                } else {
                    int lastSpace = text.lastIndexOf(32, lineEnd);
                    if (lastSpace > index) {
                        lineEnd = lastSpace;
                        next = lastSpace + 1;
                    } else {
                        next = lineEnd + 1;
                    }
                }
            }
            if (sb.length() > 0) {
                sb.append(hangingIndent);
            } else {
                lineWidth -= hangingIndent.length();
            }
            sb.append(text.substring(index, lineEnd));
            sb.append('\n');
            index = next;
        }
        return sb.toString();
    }

    public static int parseLocalizedInt(@NonNull String string) throws ParseException {
        if (string.isEmpty()) {
            return 0;
        }
        return NumberFormat.getIntegerInstance().parse(string).intValue();
    }

    public static int parseLocalizedInt(@NonNull String string, int defaultValue) {
        try {
            return SdkUtils.parseLocalizedInt(string);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static double parseLocalizedDouble(@NonNull String string) throws ParseException {
        if (string.isEmpty()) {
            return 0.0;
        }
        return NumberFormat.getNumberInstance().parse(string).doubleValue();
    }

    public static double parseLocalizedDouble(@NonNull String string, double defaultValue) {
        try {
            return SdkUtils.parseLocalizedDouble(string);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    @NonNull
    public static File urlToFile(@NonNull String url) throws MalformedURLException {
        return SdkUtils.urlToFile(new URL(url));
    }

    @NonNull
    public static File urlToFile(@NonNull URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            MalformedURLException ex = new MalformedURLException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static String fileToUrlString(@NonNull File file) throws MalformedURLException {
        return SdkUtils.fileToUrl(file).toExternalForm();
    }

    public static URL fileToUrl(@NonNull File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static String createPathComment(@NonNull File file, boolean includePadding) throws MalformedURLException {
        String url = SdkUtils.fileToUrlString(file);
        int dashes = url.indexOf("--");
        if (dashes != -1) {
            url = url.replace("--", "%2D%2D");
        }
        if (includePadding) {
            return " From: " + url + ' ';
        }
        return FILENAME_PREFIX + url;
    }

    public static void copyXmlWithSourceReference(@NonNull File from, @NonNull File to) throws IOException {
        SdkUtils.copyXmlWithComment(from, to, SdkUtils.createPathComment(from, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyXmlWithComment(@NonNull File from, @NonNull File to, @Nullable String comment) throws IOException {
        assert (SdkUtils.endsWithIgnoreCase(from.getPath(), ".xml")) : from;
        int successfulOps = 0;
        FileInputStream in = new FileInputStream(from);
        try {
            FileOutputStream out = new FileOutputStream(to, false);
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)out);
                ++successfulOps;
                if (comment != null) {
                    String commentText = "<!--" + XmlUtils.toXmlTextValue(comment) + "-->";
                    byte[] suffix = commentText.getBytes(Charsets.UTF_8);
                    out.write(suffix);
                }
                Closeables.close(out, successfulOps < 1);
            }
            catch (Throwable throwable) {
                Closeables.close(out, successfulOps < 1);
                ++successfulOps;
                throw throwable;
            }
            Closeables.close(in, ++successfulOps < 2);
        }
        catch (Throwable throwable) {
            Closeables.close(in, successfulOps < 2);
            throw throwable;
        }
    }
}

