/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.gradle.eclipse.EclipseProject;
import com.android.tools.gradle.eclipse.ImportModule;
import com.android.tools.gradle.eclipse.ImportSummary;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.android.utils.StdLogger;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.primitives.Bytes;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GradleImport {
    public static final String NL = SdkUtils.getLineSeparator();
    public static final int CURRENT_COMPILE_VERSION = 19;
    public static final String CURRENT_BUILD_TOOLS_VERSION = "19.0.1";
    public static final String ANDROID_GRADLE_PLUGIN = "com.android.tools.build:gradle:0.8.+";
    public static final String MAVEN_URL_PROPERTY = "android.mavenRepoUrl";
    private static final String WORKSPACE_PROPERTY = "android.eclipseWorkspace";
    static final String MAVEN_REPOSITORY;
    public static final String ECLIPSE_DOT_CLASSPATH = ".classpath";
    public static final String ECLIPSE_DOT_PROJECT = ".project";
    public static final String IMPORT_SUMMARY_TXT = "import-summary.txt";
    static final boolean DECLARE_GLOBAL_REPOSITORIES = true;
    private List<? extends ImportModule> mRootModules;
    private Set<ImportModule> mModules;
    private ImportSummary mSummary;
    private File mWorkspaceLocation;
    private File mGradleWrapperLocation;
    private File mSdkLocation;
    private File mNdkLocation;
    private SdkManager mSdkManager;
    private Set<String> mHandledJars = Sets.newHashSet();
    private Map<String, File> mWorkspaceProjects;
    private boolean mGradleNameStyle = true;
    private boolean mReplaceJars = true;
    private boolean mReplaceLibs = true;
    private final List<String> mWarnings = Lists.newArrayList();
    private final List<String> mErrors = Lists.newArrayList();
    private Map<String, File> mPathMap = Maps.newTreeMap();
    private Map<File, EclipseProject> mProjectMap = Maps.newHashMap();

    public GradleImport() {
        String workspace = System.getProperty(WORKSPACE_PROPERTY);
        if (workspace != null) {
            this.mWorkspaceLocation = new File(workspace);
        }
    }

    public void importProjects(@NonNull List<File> projectDirs) throws IOException {
        this.mSummary = new ImportSummary(this);
        this.mProjectMap.clear();
        this.mHandledJars.clear();
        this.mWarnings.clear();
        this.mErrors.clear();
        this.mWorkspaceProjects = null;
        this.mRootModules = Collections.emptyList();
        this.mModules = Sets.newHashSet();
        for (File file : projectDirs) {
            if (file.isFile()) {
                assert (!file.isDirectory());
                file = file.getParentFile();
            }
            this.guessWorkspace(file);
            if (GradleImport.isAdtProjectDir(file)) {
                this.guessSdk(file);
                this.guessNdk(file);
                try {
                    EclipseProject.getProject(this, file);
                    continue;
                }
                catch (ImportException importException) {
                    return;
                }
                catch (Exception exception) {
                    this.reportError(null, file, exception.toString(), false);
                    return;
                }
            }
            this.reportError(null, file, "Not a recognized project: " + file, false);
            return;
        }
        HashSet projects = Sets.newHashSet(this.mProjectMap.values());
        this.mRootModules = EclipseProject.performImport(this, projects);
        for (ImportModule importModule : this.mRootModules) {
            this.mModules.add(importModule);
            this.mModules.addAll(importModule.getAllDependencies());
        }
    }

    public static boolean isEclipseProjectDir(@Nullable File file) {
        return file != null && file.isDirectory() && new File(file, ECLIPSE_DOT_CLASSPATH).exists() && new File(file, ECLIPSE_DOT_PROJECT).exists();
    }

    public static boolean isAdtProjectDir(@Nullable File file) {
        return new File(file, "AndroidManifest.xml").exists() && (GradleImport.isEclipseProjectDir(file) || new File(file, "res").exists() && new File(file, "src").exists());
    }

    @NonNull
    public GradleImport setGradleWrapperLocation(@NonNull File gradleWrapper) {
        this.mGradleWrapperLocation = gradleWrapper;
        return this;
    }

    @NonNull
    public GradleImport setSdkLocation(@Nullable File sdkLocation) {
        this.mSdkLocation = sdkLocation;
        return this;
    }

    @Nullable
    public File getSdkLocation() {
        return this.mSdkLocation;
    }

    @NonNull
    public GradleImport setSdkManager(@NonNull SdkManager sdkManager) {
        this.mSdkManager = sdkManager;
        this.mSdkLocation = new File(sdkManager.getLocation());
        return this;
    }

    @Nullable
    public SdkManager getSdkManager() {
        if (this.mSdkManager == null && this.mSdkLocation != null && this.mSdkLocation.exists()) {
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            this.mSdkManager = SdkManager.createManager(this.mSdkLocation.getPath(), (ILogger)logger);
        }
        return this.mSdkManager;
    }

    @NonNull
    public GradleImport setNdkLocation(@Nullable File ndkLocation) {
        this.mNdkLocation = ndkLocation;
        return this;
    }

    @Nullable
    public File getNdkLocation() {
        return this.mNdkLocation;
    }

    public GradleImport setEclipseWorkspace(@NonNull File workspace) {
        this.mWorkspaceLocation = workspace;
        assert (this.mWorkspaceLocation.exists()) : workspace.getPath();
        this.mWorkspaceProjects = null;
        return this;
    }

    @Nullable
    public File getEclipseWorkspace() {
        return this.mWorkspaceLocation;
    }

    @NonNull
    public GradleImport setReplaceJars(boolean replaceJars) {
        this.mReplaceJars = replaceJars;
        return this;
    }

    public boolean isReplaceJars() {
        return this.mReplaceJars;
    }

    public boolean isReplaceLibs() {
        return this.mReplaceLibs;
    }

    public GradleImport setReplaceLibs(boolean replaceLibs) {
        this.mReplaceLibs = replaceLibs;
        return this;
    }

    @NonNull
    public GradleImport setGradleNameStyle(boolean lowerCase) {
        this.mGradleNameStyle = lowerCase;
        return this;
    }

    public boolean isGradleNameStyle() {
        return this.mGradleNameStyle;
    }

    private void guessWorkspace(@NonNull File projectDir) {
        if (this.mWorkspaceLocation == null) {
            for (File dir = projectDir.getParentFile(); dir != null; dir = dir.getParentFile()) {
                if (!GradleImport.isEclipseWorkspaceDir(dir)) continue;
                this.setEclipseWorkspace(dir);
                break;
            }
        }
    }

    private void guessSdk(@NonNull File projectDir) {
        if (this.mSdkLocation == null) {
            this.mSdkLocation = GradleImport.getDirFromLocalProperties(projectDir, "sdk.dir");
            if (this.mSdkLocation == null && this.mWorkspaceLocation != null) {
                this.mSdkLocation = this.getDirFromWorkspaceSetting(this.getAdtSettingsFile(), "com.android.ide.eclipse.adt.sdk");
            }
        }
    }

    private void guessNdk(@NonNull File projectDir) {
        if (this.mNdkLocation == null) {
            this.mNdkLocation = GradleImport.getDirFromLocalProperties(projectDir, "ndk.dir");
            if (this.mNdkLocation == null && this.mWorkspaceLocation != null) {
                this.mNdkLocation = this.getDirFromWorkspaceSetting(this.getNdkSettingsFile(), "ndkLocation");
            }
        }
    }

    @Nullable
    private static File getDirFromLocalProperties(@NonNull File projectDir, @NonNull String property) {
        File localProperties = new File(projectDir, "local.properties");
        if (localProperties.exists()) {
            try {
                String sdk;
                Properties properties = GradleImport.getProperties(localProperties);
                if (properties != null && (sdk = properties.getProperty(property)) != null) {
                    File dir = new File(sdk);
                    if (dir.exists()) {
                        return dir;
                    }
                    dir = new File(sdk.replace('/', File.separatorChar));
                    if (dir.exists()) {
                        return dir;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private File getDirFromWorkspaceSetting(@NonNull File settings, @NonNull String property) {
        if (this.mWorkspaceLocation != null && settings.exists()) {
            try {
                Properties properties = GradleImport.getProperties(settings);
                if (properties != null) {
                    String path = properties.getProperty(property);
                    File dir = new File(path);
                    if (dir.exists()) {
                        return dir;
                    }
                    dir = new File(path.replace('/', File.separatorChar));
                    if (dir.exists()) {
                        return dir;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isEclipseWorkspaceDir(@NonNull File file) {
        return file.isDirectory() && new File(file, ".metadata" + File.separator + "version.ini").exists();
    }

    @Nullable
    public File resolveWorkspacePath(@Nullable EclipseProject fromProject, @NonNull String path, boolean record) {
        if (path.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, File> entry : this.mPathMap.entrySet()) {
            File resolved;
            String workspacePath = entry.getKey();
            File file = entry.getValue();
            if (file == null || !path.startsWith(workspacePath)) continue;
            if (path.equals(workspacePath)) {
                return file;
            }
            if ((path = path.substring(workspacePath.length())).charAt(0) == '/' || path.charAt(0) == File.separatorChar) {
                path = path.substring(1);
            }
            if (!(resolved = new File(file, path.replace('/', File.separatorChar))).exists()) continue;
            return resolved;
        }
        if (fromProject != null && this.mWorkspaceLocation == null) {
            this.guessWorkspace(fromProject.getDir());
        }
        if (this.mWorkspaceLocation != null) {
            File project;
            char first = path.charAt(0);
            if (first != '/') {
                return null;
            }
            File f = new File(this.mWorkspaceLocation, path.substring(1).replace('/', File.separatorChar));
            if (f.exists()) {
                this.mPathMap.put(path, f);
                return f;
            }
            if (this.mWorkspaceProjects == null) {
                this.mWorkspaceProjects = Maps.newHashMap();
                File projectDir = new File(this.mWorkspaceLocation, ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.resources" + File.separator + ".projects");
                File[] projects = projectDir.exists() ? projectDir.listFiles() : null;
                byte[] target = "URI//file:".getBytes(Charsets.US_ASCII);
                if (projects != null) {
                    for (File project2 : projects) {
                        File location = new File(project2, ".location");
                        if (!location.exists()) continue;
                        try {
                            int end;
                            byte[] bytes = Files.toByteArray((File)location);
                            int start = Bytes.indexOf((byte[])bytes, (byte[])target);
                            if (start == -1) continue;
                            for (end = start + target.length; end < bytes.length && bytes[end] != 0; ++end) {
                            }
                            try {
                                int length = end - start;
                                String s = new String(bytes, start, length, Charsets.UTF_8);
                                s = s.substring(5);
                                File file = SdkUtils.urlToFile((String)s);
                                if (!file.exists()) continue;
                                String name = project2.getName();
                                this.mWorkspaceProjects.put('/' + name, file);
                            }
                            catch (Throwable t) {}
                        }
                        catch (IOException e) {
                            this.reportWarning((ImportModule)null, location, "Can't read .location file");
                        }
                    }
                }
            }
            if ((project = this.mWorkspaceProjects.get(path)) != null) {
                this.mPathMap.put(path, project);
                return project;
            }
            for (Map.Entry<String, File> entry : this.mWorkspaceProjects.entrySet()) {
                File resolved;
                String workspacePath = entry.getKey();
                File file = entry.getValue();
                if (file == null || !path.startsWith(workspacePath)) continue;
                if (path.equals(workspacePath)) {
                    return file;
                }
                if ((path = path.substring(workspacePath.length())).charAt(0) == '/' || path.charAt(0) == File.separatorChar) {
                    path = path.substring(1);
                }
                if (!(resolved = new File(file, path.replace('/', File.separatorChar))).exists()) continue;
                return resolved;
            }
            if (record) {
                this.mPathMap.put(path, null);
            }
        } else if (record) {
            this.mPathMap.put(path, null);
        }
        return null;
    }

    public void exportProject(@NonNull File destDir, boolean allowNonEmpty) throws IOException {
        this.mSummary.setDestDir(destDir);
        this.createDestDir(destDir, allowNonEmpty);
        GradleImport.createProjectBuildGradle(new File(destDir, "build.gradle"));
        this.createSettingsGradle(new File(destDir, "settings.gradle"));
        this.exportGradleWrapper(destDir);
        this.exportLocalProperties(destDir);
        for (ImportModule importModule : this.mRootModules) {
            this.exportModule(new File(destDir, importModule.getModuleName()), importModule);
        }
        this.mSummary.write(new File(destDir, IMPORT_SUMMARY_TXT));
    }

    private void exportGradleWrapper(@NonNull File destDir) throws IOException {
        if (this.mGradleWrapperLocation != null && this.mGradleWrapperLocation.exists()) {
            File gradlewDest = new File(destDir, "gradlew");
            this.copyDir(new File(this.mGradleWrapperLocation, "gradlew"), gradlewDest, null);
            boolean madeExecutable = gradlewDest.setExecutable(true);
            if (!madeExecutable) {
                this.reportWarning((ImportModule)null, gradlewDest, "Could not make gradle wrapper script executable");
            }
            this.copyDir(new File(this.mGradleWrapperLocation, "gradlew.bat"), new File(destDir, "gradlew.bat"), null);
            this.copyDir(new File(this.mGradleWrapperLocation, "gradle"), new File(destDir, "gradle"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportLocalProperties(@NonNull File destDir) throws IOException {
        boolean needsNdk = this.needsNdk();
        if (this.mNdkLocation != null && needsNdk || this.mSdkLocation != null) {
            Properties properties = new Properties();
            if (this.mSdkLocation != null) {
                properties.put("sdk.dir", this.mSdkLocation.getPath());
            }
            if (this.mNdkLocation != null && needsNdk) {
                properties.put("ndk.dir", this.mNdkLocation.getPath());
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(new File(destDir, "local.properties"));
                properties.store(out, "# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n# Location of the SDK. This is only used by Gradle.\n");
            }
            catch (Throwable throwable) {
                Closeables.close(out, (boolean)true);
                throw throwable;
            }
            Closeables.close((Closeable)out, (boolean)true);
        }
    }

    public boolean needsNdk() {
        for (ImportModule module : this.mModules) {
            if (!module.isNdkProject()) continue;
            return true;
        }
        return false;
    }

    private void exportModule(File destDir, ImportModule module) throws IOException {
        this.mkdirs(destDir);
        this.createModuleBuildGradle(new File(destDir, "build.gradle"), module);
        module.copyInto(destDir);
    }

    public void mkdirs(@NonNull File destDir) throws IOException {
        boolean ok;
        if (!destDir.exists() && !(ok = destDir.mkdirs())) {
            this.reportError(null, destDir, "Could not make directory " + destDir);
        }
    }

    private void createModuleBuildGradle(@NonNull File file, ImportModule module) throws IOException {
        StringBuilder sb = new StringBuilder(500);
        if (module.isApp() || module.isAndroidLibrary()) {
            String languageLevel;
            if (module.isApp()) {
                sb.append("apply plugin: 'android'").append(NL);
            } else {
                assert (module.isAndroidLibrary());
                sb.append("apply plugin: 'android-library'").append(NL);
            }
            sb.append(NL);
            sb.append("android {").append(NL);
            String compileSdkVersion = Integer.toString(module.getCompileSdkVersion());
            String minSdkVersion = Integer.toString(module.getMinSdkVersion());
            String targetSdkVersion = Integer.toString(module.getTargetSdkVersion());
            sb.append("    compileSdkVersion ").append(compileSdkVersion).append(NL);
            sb.append("    buildToolsVersion \"").append(this.getBuildToolsVersion()).append("\"").append(NL);
            sb.append(NL);
            sb.append("    defaultConfig {").append(NL);
            sb.append("        minSdkVersion ").append(minSdkVersion).append(NL);
            if (module.getTargetSdkVersion() > 1 && module.getCompileSdkVersion() > 3) {
                sb.append("        targetSdkVersion ").append(targetSdkVersion).append(NL);
            }
            if (!(languageLevel = module.getLanguageLevel()).equals("1.6")) {
                sb.append("        compileOptions {").append(NL);
                String level = languageLevel.replace('.', '_');
                sb.append("            sourceCompatibility JavaVersion.VERSION_").append(level).append(NL);
                sb.append("            targetCompatibility JavaVersion.VERSION_").append(level).append(NL);
                sb.append("        }").append(NL);
            }
            if (module.isNdkProject() && module.getNativeModuleName() != null) {
                sb.append(NL);
                sb.append("        ndk {").append(NL);
                sb.append("            moduleName \"").append(module.getNativeModuleName()).append("\"").append(NL);
                sb.append("        }").append(NL);
            }
            if (module.getInstrumentationDir() != null) {
                sb.append(NL);
                File manifestFile = new File(module.getInstrumentationDir(), "AndroidManifest.xml");
                assert (manifestFile.exists()) : manifestFile;
                Document manifest = this.getXmlDocument(manifestFile, true);
                if (manifest != null && manifest.getDocumentElement() != null) {
                    NodeList list;
                    String pkg = manifest.getDocumentElement().getAttribute("package");
                    if (pkg != null && !pkg.isEmpty()) {
                        sb.append("        testPackageName \"").append(pkg).append("\"").append(NL);
                    }
                    if ((list = manifest.getElementsByTagName("instrumentation")).getLength() > 0) {
                        Attr attr;
                        Element tag = (Element)list.item(0);
                        String runner = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (runner != null && !runner.isEmpty()) {
                            sb.append("        testInstrumentationRunner \"").append(runner).append("\"").append(NL);
                        }
                        if ((attr = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "functionalTest")) != null) {
                            sb.append("        testFunctionalTest ").append(attr.getValue()).append(NL);
                        }
                        if ((attr = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "handleProfiling")) != null) {
                            sb.append("        testHandlingProfiling ").append(attr.getValue()).append(NL);
                        }
                    }
                }
            }
            sb.append("    }").append(NL);
            sb.append(NL);
            List<File> localRules = module.getLocalProguardFiles();
            List<File> sdkRules = module.getSdkProguardFiles();
            if (!localRules.isEmpty() || !sdkRules.isEmpty()) {
                if (module.isAndroidLibrary()) {
                    sb.append("    release {").append(NL);
                    sb.append("        runProguard true").append(NL);
                    sb.append("        proguardFiles ");
                    sb.append(GradleImport.generateProguardFileList(localRules, sdkRules)).append(NL);
                    sb.append("    }").append(NL);
                } else {
                    sb.append("    buildTypes {").append(NL);
                    sb.append("        release {").append(NL);
                    sb.append("            runProguard true").append(NL);
                    sb.append("            proguardFiles ");
                    sb.append(GradleImport.generateProguardFileList(localRules, sdkRules)).append(NL);
                    sb.append("        }").append(NL);
                    sb.append("    }").append(NL);
                }
            } else if (module.isAndroidLibrary()) {
                sb.append("    release {").append(NL);
                sb.append("        runProguard false").append(NL);
                sb.append("        proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard-rules.txt'").append(NL);
                sb.append("    }").append(NL);
            } else {
                sb.append("    buildTypes {").append(NL);
                sb.append("        release {").append(NL);
                sb.append("            runProguard false").append(NL);
                sb.append("            proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard-rules.txt'").append(NL);
                sb.append("        }").append(NL);
                sb.append("    }").append(NL);
            }
            sb.append("}").append(NL);
            GradleImport.appendDependencies(sb, module);
        } else if (module.isJavaLibrary()) {
            sb.append("apply plugin: 'java'").append(NL);
            String languageLevel = module.getLanguageLevel();
            if (!languageLevel.equals("1.6")) {
                sb.append(NL);
                sb.append("sourceCompatibility = \"");
                sb.append(languageLevel);
                sb.append("\"").append(NL);
                sb.append("targetCompatibility = \"");
                sb.append(languageLevel);
                sb.append("\"").append(NL);
            }
            GradleImport.appendDependencies(sb, module);
        } else assert (false) : module;
        Files.write((CharSequence)sb.toString(), (File)file, (Charset)Charsets.UTF_8);
    }

    String getBuildToolsVersion() {
        BuildToolInfo buildTool;
        SdkManager sdkManager = this.getSdkManager();
        if (sdkManager != null && (buildTool = sdkManager.getLatestBuildTool()) != null) {
            return buildTool.getRevision().toString();
        }
        return CURRENT_BUILD_TOOLS_VERSION;
    }

    private static String generateProguardFileList(List<File> localRules, List<File> sdkRules) {
        assert (!localRules.isEmpty() || !sdkRules.isEmpty());
        StringBuilder sb = new StringBuilder();
        for (File rule : sdkRules) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("getDefaultProguardFile('");
            sb.append(GradleImport.escapeGroovyStringLiteral(rule.getName()));
            sb.append("')");
        }
        for (File rule : localRules) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'");
            sb.append(GradleImport.escapeGroovyStringLiteral(rule.getName()));
            sb.append("'");
        }
        return sb.toString();
    }

    private static void appendDependencies(@NonNull StringBuilder sb, @NonNull ImportModule module) throws IOException {
        if (!(module.getDirectDependencies().isEmpty() && module.getDependencies().isEmpty() && module.getJarDependencies().isEmpty() && module.getTestDependencies().isEmpty() && module.getTestJarDependencies().isEmpty())) {
            String path;
            sb.append(NL);
            sb.append("dependencies {").append(NL);
            for (ImportModule lib : module.getDirectDependencies()) {
                if (lib.isReplacedWithDependency()) continue;
                sb.append("    compile project('").append(lib.getModuleReference()).append("')").append(NL);
            }
            for (GradleCoordinate dependency : module.getDependencies()) {
                sb.append("    compile '").append(dependency.toString()).append("'").append(NL);
            }
            for (File jar : module.getJarDependencies()) {
                path = jar.getPath().replace(File.separatorChar, '/');
                sb.append("    compile files('").append(GradleImport.escapeGroovyStringLiteral(path)).append("')").append(NL);
            }
            for (GradleCoordinate dependency : module.getTestDependencies()) {
                sb.append("    instrumentTestCompile '").append(dependency.toString()).append("'").append(NL);
            }
            for (File jar : module.getTestJarDependencies()) {
                path = jar.getPath().replace(File.separatorChar, '/');
                sb.append("    instrumentTestCompile files('").append(GradleImport.escapeGroovyStringLiteral(path)).append("')").append(NL);
            }
            sb.append("}").append(NL);
        }
    }

    private static String escapeGroovyStringLiteral(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 5);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\'') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void appendRepositories(@NonNull StringBuilder sb, boolean needAndroidPlugin) {
    }

    private static void createProjectBuildGradle(@NonNull File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("// Top-level build file where you can add configuration options common to all sub-projects/modules.");
        sb.append(NL);
        sb.append("buildscript {").append(NL);
        sb.append("    repositories {").append(NL);
        sb.append("        ").append(MAVEN_REPOSITORY).append(NL);
        sb.append("    }").append(NL);
        sb.append("    dependencies {").append(NL);
        sb.append("        classpath 'com.android.tools.build:gradle:0.8.+'").append(NL);
        sb.append("    }").append(NL);
        sb.append("}").append(NL);
        sb.append(NL);
        sb.append("allprojects {").append(NL);
        sb.append("    repositories {").append(NL);
        sb.append("        ").append(MAVEN_REPOSITORY).append(NL);
        sb.append("    }").append(NL);
        sb.append("}");
        sb.append(NL);
        Files.write((CharSequence)sb.toString(), (File)file, (Charset)Charsets.UTF_8);
    }

    private void createSettingsGradle(@NonNull File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (ImportModule importModule : this.mRootModules) {
            sb.append("include '");
            sb.append(importModule.getModuleReference());
            sb.append("'");
            sb.append(NL);
        }
        Files.write((CharSequence)sb.toString(), (File)file, (Charset)Charsets.UTF_8);
    }

    private void createDestDir(@NonNull File destDir, boolean allowNonEmpty) throws IOException {
        if (destDir.exists()) {
            File[] files;
            if (!allowNonEmpty && (files = destDir.listFiles()) != null && files.length > 0) {
                throw new IOException("Destination directory " + destDir + " should be empty");
            }
        } else {
            this.mkdirs(destDir);
        }
    }

    @NonNull
    public List<String> getWarnings() {
        return this.mWarnings;
    }

    @NonNull
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void reportError(@Nullable EclipseProject project, @Nullable File file, @NonNull String message) {
        this.reportError(project, file, message, true);
    }

    public void reportError(@Nullable EclipseProject project, @Nullable File file, @NonNull String message, boolean abort) {
        String text = GradleImport.formatMessage(project != null ? project.getName() : null, file, message);
        this.mErrors.add(text);
        if (abort) {
            throw new ImportException(text);
        }
    }

    public void reportWarning(@Nullable ImportModule module, @Nullable File file, @NonNull String message) {
        String moduleName = module != null ? module.getOriginalName() : null;
        this.mWarnings.add(GradleImport.formatMessage(moduleName, file, message));
    }

    public void reportWarning(@Nullable EclipseProject project, @Nullable File file, @NonNull String message) {
        String moduleName = project != null ? project.getName() : null;
        this.mWarnings.add(GradleImport.formatMessage(moduleName, file, message));
    }

    private static String formatMessage(@Nullable String project, @Nullable File file, @NonNull String message) {
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            sb.append("Project ").append(project).append(":");
        }
        if (file != null) {
            sb.append(file.getPath());
            sb.append(":\n");
        }
        sb.append(message);
        return sb.toString();
    }

    @Nullable
    File resolvePathVariable(@Nullable EclipseProject fromProject, @NonNull String name, boolean record) throws IOException {
        File file = this.mPathMap.get(name);
        if (file != null) {
            return file;
        }
        if (fromProject != null && this.mWorkspaceLocation == null) {
            this.guessWorkspace(fromProject.getDir());
        }
        String value = null;
        Properties properties = this.getJdtSettingsProperties(false);
        if (properties != null) {
            value = properties.getProperty("org.eclipse.jdt.core.classpathVariable." + name);
        }
        if (value == null && (properties = this.getPathSettingsProperties(false)) != null) {
            value = properties.getProperty("pathvariable." + name);
        }
        if (value == null) {
            if (record) {
                this.mPathMap.put(name, null);
            }
            return null;
        }
        file = new File(value.replace('/', File.separatorChar));
        return file;
    }

    @Nullable
    private Properties getJdtSettingsProperties(boolean mustExist) throws IOException {
        File settings = this.getJdtSettingsFile();
        if (!settings.exists()) {
            if (mustExist) {
                this.reportError(null, settings, "Settings file does not exist");
            }
            return null;
        }
        return GradleImport.getProperties(settings);
    }

    private File getRuntimeSettingsDir() {
        return new File(this.getWorkspaceLocation(), ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.runtime" + File.separator + ".settings");
    }

    private File getJdtSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "org.eclipse.jdt.core.prefs");
    }

    private File getPathSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "org.eclipse.core.resources.prefs");
    }

    private File getNdkSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "com.android.ide.eclipse.ndk.prefs");
    }

    private File getAdtSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "com.android.ide.eclipse.adt.prefs");
    }

    @Nullable
    private Properties getPathSettingsProperties(boolean mustExist) throws IOException {
        File settings = this.getPathSettingsFile();
        if (!settings.exists()) {
            if (mustExist) {
                this.reportError(null, settings, "Settings file does not exist");
            }
            return null;
        }
        return GradleImport.getProperties(settings);
    }

    private File getWorkspaceLocation() {
        return this.mWorkspaceLocation;
    }

    Document getXmlDocument(File file, boolean namespaceAware) throws IOException {
        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        InputSource is = new InputSource(new StringReader(xml));
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            this.reportError(null, file, "Invalid XML file: " + file.getPath() + ":\n" + e.getMessage());
            return null;
        }
    }

    static Properties getProperties(File file) throws IOException {
        Properties properties = new Properties();
        FileReader reader = new FileReader(file);
        properties.load(reader);
        Closeables.close((Closeable)reader, (boolean)true);
        return properties;
    }

    Map<File, EclipseProject> getProjectMap() {
        return this.mProjectMap;
    }

    public ImportSummary getSummary() {
        return this.mSummary;
    }

    void registerProject(@NonNull EclipseProject project) {
        this.mProjectMap.put(project.getDir(), project);
        this.mProjectMap.put(project.getDir().getAbsoluteFile(), project);
        this.mProjectMap.put(project.getCanonicalDir(), project);
    }

    int getModuleCount() {
        int moduleCount = 0;
        for (ImportModule module : this.mModules) {
            if (module.isReplacedWithDependency()) continue;
            ++moduleCount;
        }
        return moduleCount;
    }

    public Map<String, File> getPathMap() {
        return this.mPathMap;
    }

    public void copyDir(@NonNull File source, @NonNull File dest, @Nullable CopyHandler handler) throws IOException {
        if (handler != null && handler.handle(source, dest)) {
            return;
        }
        if (source.isDirectory()) {
            if (GradleImport.isIgnoredFile(source)) {
                return;
            }
            this.mkdirs(dest);
            File[] files = source.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.copyDir(child, new File(dest, child.getName()), handler);
                }
            }
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    static boolean isIgnoredFile(File file) {
        String name = file.getName();
        return name.equals(".svn") || name.equals(".git") || name.equals(".hg") || name.equals(".DS_Store") || name.endsWith("~") && name.length() > 1;
    }

    @Nullable
    public static File computeRelativePath(@NonNull File canonicalBase, @NonNull File file) throws IOException {
        File canonical = file.getCanonicalFile();
        String canonicalPath = canonical.getPath();
        if (canonicalPath.startsWith(canonicalBase.getPath())) {
            int length = canonicalBase.getPath().length();
            if (canonicalPath.length() == length) {
                return new File(".");
            }
            if (canonicalPath.charAt(length) == File.separatorChar) {
                return new File(canonicalPath.substring(length + 1));
            }
            return new File(canonicalPath.substring(length));
        }
        return null;
    }

    void markJarHandled(@NonNull File file) {
        this.mHandledJars.add(file.getName());
    }

    boolean isJarHandled(@NonNull File file) {
        return this.mHandledJars.contains(file.getName());
    }

    private boolean haveLocalRepository(String vendor) {
        SdkManager sdkManager = this.getSdkManager();
        if (sdkManager != null) {
            LocalPkgInfo[] infos;
            LocalSdk localSdk = sdkManager.getLocalSdk();
            for (LocalPkgInfo info : infos = localSdk.getPkgsInfos(PkgType.PKG_EXTRAS)) {
                IPkgDesc d = info.getDesc();
                if (!d.hasVendorId() || !vendor.equals(d.getVendorId()) || !d.hasPath() || !"m2repository".equals(d.getPath())) continue;
                return true;
            }
        }
        if (this.mSdkLocation != null) {
            File repository = new File(this.mSdkLocation, "extras" + File.separator + vendor + File.separator + "m2repository");
            return repository.exists();
        }
        return false;
    }

    public boolean needSupportRepository() {
        return this.haveArtifact("com.android.support");
    }

    public boolean needGoogleRepository() {
        return this.haveArtifact("com.google.android.gms");
    }

    private boolean haveArtifact(String groupId) {
        for (ImportModule importModule : this.mRootModules) {
            for (GradleCoordinate dependency : importModule.getDependencies()) {
                if (!groupId.equals(dependency.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMissingSupportRepository() {
        return !this.haveLocalRepository("android");
    }

    public boolean isMissingGoogleRepository() {
        return !this.haveLocalRepository("google");
    }

    static {
        String repository = System.getProperty(MAVEN_URL_PROPERTY);
        repository = repository == null ? "mavenCentral()" : "maven { url '" + repository + "' }";
        MAVEN_REPOSITORY = repository;
    }

    public static interface CopyHandler {
        public boolean handle(@NonNull File var1, @NonNull File var2) throws IOException;
    }

    private static class ImportException
    extends RuntimeException {
        private String mMessage;

        private ImportException(@NonNull String message) {
            this.mMessage = message;
        }

        @Override
        public String getMessage() {
            return this.mMessage;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}

