/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.models.Window;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import java.util.ArrayList;

public class TreeViewModel {
    public static final double MAX_ZOOM = 2.0;
    public static final double MIN_ZOOM = 0.2;
    private Window mWindow;
    private DrawableViewNode mTree;
    private DrawableViewNode mSelectedNode;
    private DrawableViewNode.Rectangle mViewport;
    private double mZoom;
    private final ArrayList<ITreeChangeListener> mTreeChangeListeners = new ArrayList();
    private static TreeViewModel sModel;

    public static TreeViewModel getModel() {
        if (sModel == null) {
            sModel = new TreeViewModel();
        }
        return sModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Window window, ViewNode viewNode) {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            if (this.mTree != null) {
                this.mTree.viewNode.dispose();
            }
            this.mWindow = window;
            if (viewNode == null) {
                this.mTree = null;
            } else {
                this.mTree = new DrawableViewNode(viewNode);
                this.mTree.setLeft();
                this.mTree.placeRoot();
            }
            this.mViewport = null;
            this.mZoom = 1.0;
            this.mSelectedNode = null;
        }
        this.notifyTreeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(DrawableViewNode selectedNode) {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            this.mSelectedNode = selectedNode;
        }
        this.notifySelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewport(DrawableViewNode.Rectangle viewport) {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            this.mViewport = viewport;
        }
        this.notifyViewportChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(double newZoom) {
        DrawableViewNode.Point zoomPoint = null;
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            if (this.mTree != null && this.mViewport != null) {
                zoomPoint = new DrawableViewNode.Point(this.mViewport.x + this.mViewport.width / 2.0, this.mViewport.y + this.mViewport.height / 2.0);
            }
        }
        this.zoomOnPoint(newZoom, zoomPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomOnPoint(double newZoom, DrawableViewNode.Point zoomPoint) {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            if (this.mTree != null && this.mViewport != null) {
                if (newZoom < 0.2) {
                    newZoom = 0.2;
                }
                if (newZoom > 2.0) {
                    newZoom = 2.0;
                }
                this.mViewport.x = zoomPoint.x - (zoomPoint.x - this.mViewport.x) * this.mZoom / newZoom;
                this.mViewport.y = zoomPoint.y - (zoomPoint.y - this.mViewport.y) * this.mZoom / newZoom;
                this.mViewport.width = this.mViewport.width * this.mZoom / newZoom;
                this.mViewport.height = this.mViewport.height * this.mZoom / newZoom;
                this.mZoom = newZoom;
            }
        }
        this.notifyZoomChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawableViewNode getTree() {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            return this.mTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getWindow() {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            return this.mWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawableViewNode.Rectangle getViewport() {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            return this.mViewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getZoom() {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            return this.mZoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawableViewNode getSelection() {
        TreeViewModel treeViewModel = this;
        synchronized (treeViewModel) {
            return this.mSelectedNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITreeChangeListener[] getTreeChangeListenerList() {
        ITreeChangeListener[] listeners = null;
        ArrayList<ITreeChangeListener> arrayList = this.mTreeChangeListeners;
        synchronized (arrayList) {
            if (this.mTreeChangeListeners.size() == 0) {
                return null;
            }
            listeners = this.mTreeChangeListeners.toArray(new ITreeChangeListener[this.mTreeChangeListeners.size()]);
        }
        return listeners;
    }

    public void notifyTreeChanged() {
        ITreeChangeListener[] listeners = this.getTreeChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].treeChanged();
            }
        }
    }

    public void notifySelectionChanged() {
        ITreeChangeListener[] listeners = this.getTreeChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].selectionChanged();
            }
        }
    }

    public void notifyViewportChanged() {
        ITreeChangeListener[] listeners = this.getTreeChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].viewportChanged();
            }
        }
    }

    public void notifyZoomChanged() {
        ITreeChangeListener[] listeners = this.getTreeChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].zoomChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeChangeListener(ITreeChangeListener listener) {
        ArrayList<ITreeChangeListener> arrayList = this.mTreeChangeListeners;
        synchronized (arrayList) {
            this.mTreeChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeChangeListener(ITreeChangeListener listener) {
        ArrayList<ITreeChangeListener> arrayList = this.mTreeChangeListeners;
        synchronized (arrayList) {
            this.mTreeChangeListeners.remove(listener);
        }
    }

    public static interface ITreeChangeListener {
        public void treeChanged();

        public void selectionChanged();

        public void viewportChanged();

        public void zoomChanged();
    }
}

