/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageTransferHandler;
import com.android.draw9patch.ui.ImageViewer;
import com.android.draw9patch.ui.MainFrame;
import com.android.draw9patch.ui.PngFileFilter;
import com.android.draw9patch.ui.StretchesViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageEditorPanel
extends JPanel {
    private static final String EXTENSION_9PATCH = ".9.png";
    private String name;
    private BufferedImage image;
    private boolean is9Patch;
    private ImageViewer viewer;
    private StretchesViewer stretchesViewer;
    private JLabel xLabel;
    private JLabel yLabel;
    private TexturePaint texture;
    private JSlider zoomSlider;

    public ImageEditorPanel(MainFrame mainFrame, BufferedImage image, String name) {
        this.image = image;
        this.name = name;
        if (mainFrame != null) {
            this.setTransferHandler(new ImageTransferHandler(mainFrame));
        }
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.loadSupport();
        this.buildImageViewer();
        this.buildStatusPanel();
        this.checkImage();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ImageEditorPanel.this.removeAncestorListener(this);
                ImageEditorPanel.this.synchronizeImageViewerZoomLevel();
            }
        });
    }

    private void synchronizeImageViewerZoomLevel() {
        this.zoomSlider.setValue(this.viewer.getZoom());
    }

    public ImageViewer getViewer() {
        return this.viewer;
    }

    private void loadSupport() {
        try {
            URL resource = this.getClass().getResource("/images/checker.png");
            BufferedImage checker = GraphicsUtilities.loadCompatibleImage(resource);
            this.texture = new TexturePaint(checker, new Rectangle2D.Double(0.0, 0.0, checker.getWidth(), checker.getHeight()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildImageViewer() {
        this.viewer = new ImageViewer(this, this.texture, this.image, new ImageViewer.StatusBar(){

            @Override
            public void setPointerLocation(int x, int y) {
                ImageEditorPanel.this.xLabel.setText(x + " px");
                ImageEditorPanel.this.yLabel.setText(y + " px");
            }
        });
        JSplitPane splitter = new JSplitPane();
        splitter.setContinuousLayout(true);
        splitter.setResizeWeight(0.8);
        splitter.setBorder(null);
        JScrollPane scroller = new JScrollPane(this.viewer);
        scroller.setOpaque(false);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        scroller.getViewport().setOpaque(false);
        splitter.setLeftComponent(scroller);
        splitter.setRightComponent(this.buildStretchesViewer());
        this.add(splitter);
    }

    private JComponent buildStretchesViewer() {
        this.stretchesViewer = new StretchesViewer(this, this.viewer, this.texture);
        JScrollPane scroller = new JScrollPane(this.stretchesViewer);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        scroller.setHorizontalScrollBarPolicy(32);
        scroller.setVerticalScrollBarPolicy(22);
        return scroller;
    }

    private void buildStatusPanel() {
        JPanel status = new JPanel(new GridBagLayout());
        JLabel label = new JLabel();
        label.setText("Zoom: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel();
        label.setText("100%");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.zoomSlider = new JSlider(1, 16, 8);
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImageEditorPanel.this.viewer.setZoom(((JSlider)evt.getSource()).getValue());
            }
        });
        status.add((Component)this.zoomSlider, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel maxZoomLabel = new JLabel();
        maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        maxZoomLabel.setText("800%");
        status.add((Component)maxZoomLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel();
        label.setText("Patch scale: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel();
        label.setText("2x");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        JSlider jSlider = new JSlider(200, 600, 200);
        jSlider.setSnapToTicks(true);
        jSlider.putClientProperty("JComponent.sizeVariant", "small");
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImageEditorPanel.this.stretchesViewer.setScale((float)((JSlider)evt.getSource()).getValue() / 100.0f);
            }
        });
        status.add((Component)jSlider, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        maxZoomLabel = new JLabel();
        maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        maxZoomLabel.setText("6x");
        status.add((Component)maxZoomLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JCheckBox showLock = new JCheckBox("Show lock");
        showLock.setOpaque(false);
        showLock.setSelected(false);
        showLock.putClientProperty("JComponent.sizeVariant", "small");
        showLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageEditorPanel.this.viewer.setLockVisible(((JCheckBox)event.getSource()).isSelected());
            }
        });
        status.add((Component)showLock, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        JCheckBox showPatches = new JCheckBox("Show patches");
        showPatches.setOpaque(false);
        showPatches.putClientProperty("JComponent.sizeVariant", "small");
        showPatches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageEditorPanel.this.viewer.setPatchesVisible(((JCheckBox)event.getSource()).isSelected());
            }
        });
        status.add((Component)showPatches, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        JCheckBox showPadding = new JCheckBox("Show content");
        showPadding.setOpaque(false);
        showPadding.putClientProperty("JComponent.sizeVariant", "small");
        showPadding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageEditorPanel.this.stretchesViewer.setPaddingVisible(((JCheckBox)event.getSource()).isSelected());
            }
        });
        status.add((Component)showPadding, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        status.add(Box.createHorizontalGlue(), new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("X: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.xLabel = new JLabel("0px");
        this.xLabel.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)this.xLabel, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        label = new JLabel("Y: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.yLabel = new JLabel("0px");
        this.yLabel.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)this.yLabel, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.add((Component)status, "South");
    }

    private void checkImage() {
        this.is9Patch = this.name.endsWith(EXTENSION_9PATCH);
        if (!this.is9Patch) {
            this.convertTo9Patch();
        } else {
            this.ensure9Patch();
        }
    }

    private void ensure9Patch() {
        int pixel;
        int i;
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        for (i = 0; i < width; ++i) {
            pixel = this.image.getRGB(i, 0);
            if (pixel != 0 && pixel != -16777216 && pixel != -65536) {
                this.image.setRGB(i, 0, 0);
            }
            if ((pixel = this.image.getRGB(i, height - 1)) == 0 || pixel == -16777216 || pixel == -65536) continue;
            this.image.setRGB(i, height - 1, 0);
        }
        for (i = 0; i < height; ++i) {
            pixel = this.image.getRGB(0, i);
            if (pixel != 0 && pixel != -16777216 && pixel != -65536) {
                this.image.setRGB(0, i, 0);
            }
            if ((pixel = this.image.getRGB(width - 1, i)) == 0 || pixel == -16777216 || pixel == -65536) continue;
            this.image.setRGB(width - 1, i, 0);
        }
    }

    private void convertTo9Patch() {
        BufferedImage buffer = GraphicsUtilities.createTranslucentCompatibleImage(this.image.getWidth() + 2, this.image.getHeight() + 2);
        Graphics2D g2 = buffer.createGraphics();
        g2.drawImage((Image)this.image, 1, 1, null);
        g2.dispose();
        this.image = buffer;
        this.viewer.setImage(this.image);
        this.name = this.name.substring(0, this.name.lastIndexOf(46)) + EXTENSION_9PATCH;
    }

    File chooseSaveFile() {
        if (this.is9Patch) {
            return new File(this.name);
        }
        JFileChooser chooser = new JFileChooser(this.name.substring(0, this.name.lastIndexOf(File.separatorChar)));
        chooser.setFileFilter(new PngFileFilter());
        int choice = chooser.showSaveDialog(this);
        if (choice == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(EXTENSION_9PATCH)) {
                String path = file.getAbsolutePath();
                path = path.endsWith(".png") ? path.substring(0, path.lastIndexOf(".png")) + EXTENSION_9PATCH : path + EXTENSION_9PATCH;
                this.name = path;
                this.is9Patch = true;
                return new File(path);
            }
            this.is9Patch = true;
            return file;
        }
        return null;
    }

    RenderedImage getImage() {
        return this.image;
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.dispose();
        }
    }
}

