/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLEnum;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class GLUtils {
    public static String formatData(byte[] byArray, GLEnum gLEnum) {
        switch (gLEnum) {
            case GL_BYTE: {
                return GLUtils.formatBytes(byArray, false);
            }
            case GL_UNSIGNED_BYTE: {
                return GLUtils.formatBytes(byArray, true);
            }
            case GL_SHORT: {
                return GLUtils.formatShorts(byArray, false);
            }
            case GL_UNSIGNED_SHORT: {
                return GLUtils.formatShorts(byArray, true);
            }
            case GL_FIXED: {
                return GLUtils.formatInts(byArray);
            }
            case GL_FLOAT: {
                return GLUtils.formatFloats(byArray);
            }
        }
        return "";
    }

    private static String formatFloats(byte[] byArray) {
        FloatBuffer floatBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        StringBuilder stringBuilder = new StringBuilder(floatBuffer.capacity() * 3);
        while (floatBuffer.remaining() > 0) {
            stringBuilder.append(String.format("%.4f", Float.valueOf(floatBuffer.get())));
            stringBuilder.append(',');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static String formatInts(byte[] byArray) {
        IntBuffer intBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        StringBuilder stringBuilder = new StringBuilder(intBuffer.capacity() * 3);
        while (intBuffer.remaining() > 0) {
            stringBuilder.append(intBuffer.get());
            stringBuilder.append(',');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static String formatShorts(byte[] byArray, boolean bl) {
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        StringBuilder stringBuilder = new StringBuilder(shortBuffer.capacity() * 3);
        while (shortBuffer.remaining() > 0) {
            if (bl) {
                stringBuilder.append(shortBuffer.get() & 0xFFFF);
            } else {
                stringBuilder.append(shortBuffer.get());
            }
            stringBuilder.append(',');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static String formatBytes(byte[] byArray, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        StringBuilder stringBuilder = new StringBuilder(byteBuffer.capacity() * 3);
        while (byteBuffer.remaining() > 0) {
            if (bl) {
                stringBuilder.append(byteBuffer.get() & 0xFF);
            } else {
                stringBuilder.append(byteBuffer.get());
            }
            stringBuilder.append(',');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

