/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetworkCodeQualifier
extends ResourceQualifier {
    private static final int DEFAULT_CODE = -1;
    private static final Pattern sNetworkCodePattern = Pattern.compile("^mnc(\\d{1,3})$");
    private final int mCode;
    public static final String NAME = "Mobile Network Code";

    public static NetworkCodeQualifier getQualifier(String segment) {
        Matcher m = sNetworkCodePattern.matcher(segment);
        if (m.matches()) {
            String v = m.group(1);
            int code = -1;
            try {
                code = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return null;
            }
            NetworkCodeQualifier qualifier = new NetworkCodeQualifier(code);
            return qualifier;
        }
        return null;
    }

    public static String getFolderSegment(int code) {
        if (code != -1 && code >= 1 && code <= 999) {
            return String.format("mnc%1$d", code);
        }
        return "";
    }

    public NetworkCodeQualifier() {
        this(-1);
    }

    public NetworkCodeQualifier(int code) {
        this.mCode = code;
    }

    public int getCode() {
        return this.mCode;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "Network Code";
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mCode != -1;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        Matcher m = sNetworkCodePattern.matcher(value);
        if (m.matches()) {
            String v = m.group(1);
            int code = -1;
            try {
                code = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return false;
            }
            NetworkCodeQualifier qualifier = new NetworkCodeQualifier(code);
            config.setNetworkCodeQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        if (qualifier instanceof NetworkCodeQualifier) {
            return this.mCode == ((NetworkCodeQualifier)qualifier).mCode;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mCode;
    }

    @Override
    public String getFolderSegment() {
        return NetworkCodeQualifier.getFolderSegment(this.mCode);
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mCode != -1) {
            return String.format("MNC %1$d", this.mCode);
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        return this.getShortDisplayValue();
    }
}

