/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AnnotationDeclarationTemplate;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.Identifier;
import lombok.ast.JavadocContainer;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.Statement;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeMemberMixin;

public class AnnotationDeclaration
extends AbstractNode
implements TypeMember,
Statement,
TypeDeclaration,
JavadocContainer {
    private AbstractNode javadoc = null;
    private AbstractNode modifiers = this.adopt(new Modifiers());
    private AbstractNode name = this.adopt(new Identifier());
    private AbstractNode body = null;

    @Override
    public TypeBody upToTypeBody() {
        if (!(this.getParent() instanceof TypeBody)) {
            return null;
        }
        TypeBody out = (TypeBody)this.getParent();
        if (!out.rawMembers().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public CompilationUnit upIfTopLevelToCompilationUnit() {
        if (!(this.getParent() instanceof CompilationUnit)) {
            return null;
        }
        CompilationUnit out = (CompilationUnit)this.getParent();
        if (!out.rawTypeDeclarations().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public AnnotationDeclaration astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public AnnotationDeclaration rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    @Override
    public Modifiers astModifiers() {
        if (!(this.modifiers instanceof Modifiers)) {
            return null;
        }
        return (Modifiers)this.modifiers;
    }

    @Override
    public AnnotationDeclaration astModifiers(Modifiers modifiers) {
        return this.rawModifiers(modifiers);
    }

    private AnnotationDeclaration rawModifiers(Node modifiers) {
        if (modifiers == this.modifiers) {
            return this;
        }
        if (modifiers != null) {
            this.adopt((AbstractNode)modifiers);
        }
        if (this.modifiers != null) {
            this.disown(this.modifiers);
        }
        this.modifiers = (AbstractNode)modifiers;
        return this;
    }

    @Override
    public Identifier astName() {
        if (!(this.name instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.name;
    }

    @Override
    public AnnotationDeclaration astName(Identifier name) {
        return this.rawName(name);
    }

    private AnnotationDeclaration rawName(Node name) {
        if (name == this.name) {
            return this;
        }
        if (name != null) {
            this.adopt((AbstractNode)name);
        }
        if (this.name != null) {
            this.disown(this.name);
        }
        this.name = (AbstractNode)name;
        return this;
    }

    @Override
    public NormalTypeBody astBody() {
        if (!(this.body instanceof NormalTypeBody)) {
            return null;
        }
        return (NormalTypeBody)this.body;
    }

    public AnnotationDeclaration astBody(NormalTypeBody body) {
        if (body == null) {
            throw new NullPointerException("body is mandatory");
        }
        return this.rawBody(body);
    }

    @Override
    public Node rawBody() {
        return this.body;
    }

    public AnnotationDeclaration rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        if (this.modifiers != null) {
            result.add(this.modifiers);
        }
        if (this.name != null) {
            result.add(this.name);
        }
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.modifiers == original) {
            if (replacement instanceof Modifiers) {
                this.astModifiers((Modifiers)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Modifiers", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.name == original) {
            if (replacement instanceof Identifier) {
                this.astName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.modifiers == child) {
            this.disown((AbstractNode)child);
            this.modifiers = null;
            return true;
        }
        if (this.name == child) {
            this.disown((AbstractNode)child);
            this.name = null;
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAnnotationDeclaration(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        if (this.modifiers != null) {
            this.modifiers.accept(visitor);
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public AnnotationDeclaration copy() {
        AnnotationDeclaration result = new AnnotationDeclaration();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        if (this.modifiers != null) {
            result.rawModifiers(this.modifiers.copy());
        }
        if (this.name != null) {
            result.rawName(this.name.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return AnnotationDeclarationTemplate.getDescription(this);
    }

    @Override
    public boolean isInterface() {
        return AnnotationDeclarationTemplate.isInterface(this);
    }

    public TypeDeclaration upUpToTypeDeclaration() {
        return TypeMemberMixin.upUpToTypeDeclaration(this);
    }
}

