/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UserCredentials;
import com.android.sdkuilib.internal.tasks.IProgressUiProvider;

class TaskMonitorImpl
implements ITaskMonitor {
    private static final double MAX_COUNT = 10000.0;
    private double mIncCoef = 0.0;
    private double mValue = 0.0;
    private final IProgressUiProvider mUi;

    public static boolean isTaskMonitorImpl(ITaskMonitor monitor) {
        return monitor instanceof TaskMonitorImpl || monitor instanceof SubTaskMonitor;
    }

    public TaskMonitorImpl(IProgressUiProvider ui) {
        this.mUi = ui;
    }

    public IProgressUiProvider getUiProvider() {
        return this.mUi;
    }

    @Override
    public void setDescription(String format, Object ... args) {
        String text = String.format(format, args);
        this.mUi.setDescription(text);
    }

    @Override
    public void log(String format, Object ... args) {
        String text = String.format(format, args);
        this.mUi.log(text);
    }

    @Override
    public void logError(String format, Object ... args) {
        String text = String.format(format, args);
        this.mUi.logError(text);
    }

    @Override
    public void logVerbose(String format, Object ... args) {
        String text = String.format(format, args);
        this.mUi.logVerbose(text);
    }

    @Override
    public void setProgressMax(int max) {
        assert (max > 0);
        this.mUi.setProgressMax(10000);
        double d = this.mIncCoef = max > 0 ? 10000.0 / (double)max : 0.0;
        assert (this.mIncCoef > 0.0);
    }

    @Override
    public int getProgressMax() {
        return this.mIncCoef > 0.0 ? (int)(10000.0 / this.mIncCoef) : 0;
    }

    @Override
    public void incProgress(int delta) {
        if (delta > 0 && this.mIncCoef > 0.0) {
            this.internalIncProgress((double)delta * this.mIncCoef);
        }
    }

    private void internalIncProgress(double realDelta) {
        this.mValue += realDelta;
        this.mUi.setProgress((int)this.mValue);
    }

    @Override
    public int getProgress() {
        return this.mIncCoef > 0.0 ? (int)((double)this.mUi.getProgress() / this.mIncCoef) : 0;
    }

    @Override
    public boolean isCancelRequested() {
        return this.mUi.isCancelRequested();
    }

    @Override
    public boolean displayPrompt(String title, String message) {
        return this.mUi.displayPrompt(title, message);
    }

    @Override
    public UserCredentials displayLoginCredentialsPrompt(String title, String message) {
        return this.mUi.displayLoginCredentialsPrompt(title, message);
    }

    @Override
    public ITaskMonitor createSubMonitor(int tickCount) {
        assert (this.mIncCoef > 0.0);
        assert (tickCount > 0);
        return new SubTaskMonitor(this, null, this.mValue, (double)tickCount * this.mIncCoef);
    }

    public void error(Throwable throwable, String errorFormat, Object ... arg) {
        if (errorFormat != null) {
            this.logError("Error: " + errorFormat, arg);
        }
        if (throwable != null) {
            this.logError("%s", throwable.getMessage());
        }
    }

    public void warning(@NonNull String warningFormat, Object ... arg) {
        this.log("Warning: " + warningFormat, arg);
    }

    public void info(@NonNull String msgFormat, Object ... arg) {
        this.log(msgFormat, arg);
    }

    public void verbose(@NonNull String msgFormat, Object ... arg) {
        this.log(msgFormat, arg);
    }

    private static class SubTaskMonitor
    implements ISubTaskMonitor {
        private final TaskMonitorImpl mRoot;
        private final ISubTaskMonitor mParent;
        private final double mStart;
        private final double mSpan;
        private double mSubValue;
        private double mSubCoef;

        public SubTaskMonitor(TaskMonitorImpl taskMonitor, ISubTaskMonitor parent, double start, double span) {
            this.mRoot = taskMonitor;
            this.mParent = parent;
            this.mStart = start;
            this.mSpan = span;
            this.mSubValue = start;
        }

        @Override
        public boolean isCancelRequested() {
            return this.mRoot.isCancelRequested();
        }

        @Override
        public void setDescription(String format, Object ... args) {
            this.mRoot.setDescription(format, args);
        }

        @Override
        public void log(String format, Object ... args) {
            this.mRoot.log(format, args);
        }

        @Override
        public void logError(String format, Object ... args) {
            this.mRoot.logError(format, args);
        }

        @Override
        public void logVerbose(String format, Object ... args) {
            this.mRoot.logVerbose(format, args);
        }

        @Override
        public void setProgressMax(int max) {
            assert (max > 0);
            double d = this.mSubCoef = max > 0 ? this.mSpan / (double)max : 0.0;
            assert (this.mSubCoef > 0.0);
        }

        @Override
        public int getProgressMax() {
            return this.mSubCoef > 0.0 ? (int)(this.mSpan / this.mSubCoef) : 0;
        }

        @Override
        public int getProgress() {
            assert (this.mSubValue == this.mStart || this.mSubCoef > 0.0);
            return this.mSubCoef > 0.0 ? (int)((this.mSubValue - this.mStart) / this.mSubCoef) : 0;
        }

        @Override
        public void incProgress(int delta) {
            if (delta > 0 && this.mSubCoef > 0.0) {
                this.subIncProgress((double)delta * this.mSubCoef);
            }
        }

        @Override
        public void subIncProgress(double realDelta) {
            this.mSubValue += realDelta;
            if (this.mParent != null) {
                this.mParent.subIncProgress(realDelta);
            } else {
                this.mRoot.internalIncProgress(realDelta);
            }
        }

        @Override
        public boolean displayPrompt(String title, String message) {
            return this.mRoot.displayPrompt(title, message);
        }

        @Override
        public UserCredentials displayLoginCredentialsPrompt(String title, String message) {
            return this.mRoot.displayLoginCredentialsPrompt(title, message);
        }

        @Override
        public ITaskMonitor createSubMonitor(int tickCount) {
            assert (this.mSubCoef > 0.0);
            assert (tickCount > 0);
            return new SubTaskMonitor(this.mRoot, this, this.mSubValue, (double)tickCount * this.mSubCoef);
        }

        public void error(Throwable throwable, String errorFormat, Object ... arg) {
            this.mRoot.error(throwable, errorFormat, arg);
        }

        public void warning(@NonNull String warningFormat, Object ... arg) {
            this.mRoot.warning(warningFormat, arg);
        }

        public void info(@NonNull String msgFormat, Object ... arg) {
            this.mRoot.info(msgFormat, arg);
        }

        public void verbose(@NonNull String msgFormat, Object ... arg) {
            this.mRoot.verbose(msgFormat, arg);
        }
    }

    private static interface ISubTaskMonitor
    extends ITaskMonitor {
        public void subIncProgress(double var1);
    }
}

