/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.io.FileOp;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.UpdaterBaseDialog;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AboutDialog
extends UpdaterBaseDialog {
    public AboutDialog(Shell parentShell, SwtUpdaterData swtUpdaterData) {
        super(parentShell, swtUpdaterData, "About");
        assert (swtUpdaterData != null);
    }

    @Override
    protected void createContents() {
        Image image;
        super.createContents();
        Shell shell = this.getShell();
        shell.setMinimumSize(new Point(450, 150));
        shell.setSize(450, 150);
        GridLayoutBuilder.create((Composite)shell).columns(3);
        Label logo = new Label((Composite)shell, 0);
        ImageFactory imgf = this.getSwtUpdaterData() == null ? null : this.getSwtUpdaterData().getImageFactory();
        Image image2 = image = imgf == null ? null : imgf.getImageByName("sdkman_logo_128.png");
        if (image != null) {
            logo.setImage(image);
        }
        Label label = new Label((Composite)shell, 0);
        GridDataBuilder.create((Control)label).hFill().hGrab().hSpan(2);
        label.setText(String.format("Android SDK Manager.\nRevision %1$s\nAdd-on XML Schema #%2$d\nRepository XML Schema #%3$d\nCopyright (C) 2009-2012 The Android Open Source Project.", this.getRevision(), 6, 9));
        Label filler = new Label((Composite)shell, 0);
        GridDataBuilder.create((Control)filler).fill().grab().hSpan(2);
        this.createCloseButton();
    }

    protected void checkSubclass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRevision() {
        Properties p = new Properties();
        try {
            File sourceProp = FileOp.append(this.getSwtUpdaterData().getOsSdkRoot(), "tools", "source.properties");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sourceProp);
                p.load(fis);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            String revision = p.getProperty("Pkg.Revision");
            if (revision != null) {
                return revision;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "?";
    }
}

