/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.Fat32BootSector;
import de.waldheinz.fs.fat.Sector;
import java.io.IOException;

final class FsInfoSector
extends Sector {
    public static final int FREE_CLUSTERS_OFFSET = 488;
    public static final int LAST_ALLOCATED_OFFSET = 492;
    public static final int SIGNATURE_OFFSET = 510;

    private FsInfoSector(BlockDevice device, long offset) {
        super(device, offset, 512);
    }

    public static FsInfoSector read(Fat32BootSector bs) throws IOException {
        FsInfoSector result = new FsInfoSector(bs.getDevice(), FsInfoSector.offset(bs));
        result.read();
        result.verify();
        return result;
    }

    public static FsInfoSector create(Fat32BootSector bs) throws IOException {
        int offset = FsInfoSector.offset(bs);
        if (offset == 0) {
            throw new IOException("creating a FS info sector at offset 0 is strange");
        }
        FsInfoSector result = new FsInfoSector(bs.getDevice(), FsInfoSector.offset(bs));
        result.init();
        result.write();
        return result;
    }

    private static int offset(Fat32BootSector bs) {
        return bs.getFsInfoSectorNr() * bs.getBytesPerSector();
    }

    public void setFreeClusterCount(long value) {
        if (this.getFreeClusterCount() == value) {
            return;
        }
        this.set32(488, value);
    }

    public long getFreeClusterCount() {
        return this.get32(488);
    }

    public void setLastAllocatedCluster(long value) {
        if (this.getLastAllocatedCluster() == value) {
            return;
        }
        super.set32(492, value);
    }

    public long getLastAllocatedCluster() {
        return super.get32(492);
    }

    private void init() {
        this.buffer.position(0);
        this.buffer.put((byte)82);
        this.buffer.put((byte)82);
        this.buffer.put((byte)97);
        this.buffer.put((byte)65);
        this.buffer.position(484);
        this.buffer.put((byte)114);
        this.buffer.put((byte)114);
        this.buffer.put((byte)65);
        this.buffer.put((byte)97);
        this.setFreeClusterCount(-1L);
        this.setLastAllocatedCluster(2L);
        this.buffer.position(510);
        this.buffer.put((byte)85);
        this.buffer.put((byte)-86);
        this.markDirty();
    }

    private void verify() throws IOException {
        if (this.get8(510) != 85 || this.get8(511) != 170) {
            throw new IOException("invalid FS info sector signature");
        }
    }

    public String toString() {
        return FsInfoSector.class.getSimpleName() + " [freeClusterCount=" + this.getFreeClusterCount() + ", lastAllocatedCluster=" + this.getLastAllocatedCluster() + ", offset=" + this.getOffset() + ", dirty=" + this.isDirty() + "]";
    }
}

