/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IExactApiLevelDependency;
import com.android.sdklib.internal.repository.packages.ILayoutlibVersion;
import com.android.sdklib.internal.repository.packages.IPlatformDependency;
import com.android.sdklib.internal.repository.packages.LayoutlibVersionMixin;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class AddonPackage
extends MajorRevisionPackage
implements IAndroidVersionProvider,
IPlatformDependency,
IExactApiLevelDependency,
ILayoutlibVersion {
    private final String mVendorId;
    private final String mVendorDisplay;
    private final String mNameId;
    private final String mDisplayName;
    private final AndroidVersion mVersion;
    private final IPkgDesc mPkgDesc;
    private final LayoutlibVersionMixin mLayoutlibVersion;
    private final Lib[] mLibs;

    public AddonPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        String nameId = PackageParserUtils.getXmlString(packageNode, "name-id");
        String nameDisp = PackageParserUtils.getXmlString(packageNode, "name-display");
        String name = PackageParserUtils.getXmlString(packageNode, "name");
        if (nameDisp.length() == 0) {
            nameDisp = name;
        }
        if (nameId.length() == 0) {
            nameId = this.sanitizeDisplayToNameId(name.length() > 0 ? name : nameDisp);
        }
        assert (nameId.length() > 0);
        assert (nameDisp.length() > 0);
        this.mNameId = nameId.trim();
        this.mDisplayName = nameDisp.trim();
        String vendorId = PackageParserUtils.getXmlString(packageNode, "vendor-id");
        String vendorDisp = PackageParserUtils.getXmlString(packageNode, "vendor-display");
        String vendor = PackageParserUtils.getXmlString(packageNode, "vendor");
        if (vendorDisp.length() == 0) {
            vendorDisp = vendor;
        }
        if (vendorId.length() == 0) {
            boolean hasVendor = vendor.length() > 0;
            vendorId = this.sanitizeDisplayToNameId(hasVendor ? vendor : vendorDisp);
        }
        assert (vendorId.length() > 0);
        assert (vendorDisp.length() > 0);
        this.mVendorId = vendorId.trim();
        this.mVendorDisplay = vendorDisp.trim();
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        this.mVersion = new AndroidVersion(apiLevel, null);
        this.mLibs = this.parseLibs(PackageParserUtils.findChildElement(packageNode, "libs"));
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        this.mPkgDesc = PkgDesc.newAddon(this.mVersion, (MajorRevision)this.getRevision(), this.mVendorId, this.mNameId);
    }

    public static Package create(IAndroidTarget target, Properties props) {
        return new AddonPackage(target, props);
    }

    protected AddonPackage(IAndroidTarget target, Properties props) {
        this(null, target, props);
    }

    protected AddonPackage(SdkSource source, IAndroidTarget target, Properties props) {
        super(source, props, target.getRevision(), null, target.getDescription(), null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), target.getLocation());
        String nameId = AddonPackage.getProperty(props, "Addon.NameId", "");
        String nameDisp = AddonPackage.getProperty(props, "Addon.NameDisplay", "");
        String name = AddonPackage.getProperty(props, "Addon.Name", target.getName());
        if (nameDisp.length() == 0) {
            nameDisp = name;
        }
        if (nameId.length() == 0) {
            nameId = this.sanitizeDisplayToNameId(name.length() > 0 ? name : nameDisp);
        }
        assert (nameId.length() > 0);
        assert (nameDisp.length() > 0);
        this.mNameId = nameId.trim();
        this.mDisplayName = nameDisp.trim();
        String vendorId = AddonPackage.getProperty(props, "Addon.VendorId", "");
        String vendorDisp = AddonPackage.getProperty(props, "Addon.VendorDisplay", "");
        String vendor = AddonPackage.getProperty(props, "Addon.Vendor", target.getVendor());
        if (vendorDisp.length() == 0) {
            vendorDisp = vendor;
        }
        if (vendorId.length() == 0) {
            boolean hasVendor = vendor.length() > 0;
            vendorId = this.sanitizeDisplayToNameId(hasVendor ? vendor : vendorDisp);
        }
        assert (vendorId.length() > 0);
        assert (vendorDisp.length() > 0);
        this.mVendorId = vendorId.trim();
        this.mVendorDisplay = vendorDisp.trim();
        this.mVersion = target.getVersion();
        this.mLayoutlibVersion = new LayoutlibVersionMixin(props);
        IAndroidTarget.IOptionalLibrary[] optLibs = target.getOptionalLibraries();
        if (optLibs == null || optLibs.length == 0) {
            this.mLibs = new Lib[0];
        } else {
            this.mLibs = new Lib[optLibs.length];
            for (int i = 0; i < optLibs.length; ++i) {
                this.mLibs[i] = new Lib(optLibs[i].getName(), optLibs[i].getDescription());
            }
        }
        this.mPkgDesc = PkgDesc.newAddon(this.mVersion, (MajorRevision)this.getRevision(), this.mVendorId, this.mNameId);
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    public static Package createBroken(String archiveOsPath, Properties sourceProps, Map<String, String> addonProps, String error) {
        String name = AddonPackage.getProperty(sourceProps, "Addon.NameDisplay", AddonPackage.getProperty(sourceProps, "Addon.Name", addonProps.get("name")));
        String vendor = AddonPackage.getProperty(sourceProps, "Addon.VendorDisplay", AddonPackage.getProperty(sourceProps, "Addon.Vendor", addonProps.get("vendor")));
        String api = addonProps.get("api");
        String revision = addonProps.get("revision");
        String shortDesc = String.format("%1$s by %2$s, Android API %3$s, revision %4$s [*]", name, vendor, api, revision);
        String longDesc = String.format("%1$s\n[*] Addon failed to load: %2$s", shortDesc, error);
        int apiLevel = 0;
        try {
            apiLevel = Integer.parseInt(api);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        int intRevision = 0;
        try {
            intRevision = Integer.parseInt(revision);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        IPkgDesc desc = PkgDesc.newAddon(new AndroidVersion(apiLevel, null), new MajorRevision(intRevision), vendor, name);
        return new BrokenPackage(null, shortDesc, longDesc, 0, apiLevel, archiveOsPath, desc);
    }

    @Override
    public int getExactApiLevel() {
        return this.mVersion.getApiLevel();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        this.mLayoutlibVersion.saveProperties(props);
        props.setProperty("Addon.NameId", this.mNameId);
        props.setProperty("Addon.NameDisplay", this.mDisplayName);
        props.setProperty("Addon.VendorId", this.mVendorId);
        props.setProperty("Addon.VendorDisplay", this.mVendorDisplay);
    }

    private Lib[] parseLibs(Node libsNode) {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        if (libsNode != null) {
            String nsUri = libsNode.getNamespaceURI();
            for (Node child = libsNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"lib".equals(child.getLocalName())) continue;
                libs.add(this.parseLib(child));
            }
        }
        return libs.toArray(new Lib[libs.size()]);
    }

    private Lib parseLib(Node libNode) {
        return new Lib(PackageParserUtils.getXmlString(libNode, "name"), PackageParserUtils.getXmlString(libNode, "description"));
    }

    @NonNull
    public String getVendorId() {
        return this.mVendorId;
    }

    @NonNull
    public String getDisplayVendor() {
        return this.mVendorDisplay;
    }

    @NonNull
    public String getNameId() {
        return this.mNameId;
    }

    @NonNull
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @NonNull
    public Lib[] getLibs() {
        return this.mLibs;
    }

    @Override
    @NonNull
    public Pair<Integer, Integer> getLayoutlibVersion() {
        return this.mLayoutlibVersion.getLayoutlibVersion();
    }

    @Override
    @NonNull
    public String installId() {
        return this.encodeAddonName();
    }

    @Override
    public String getListDescription() {
        return String.format("%1$s%2$s", this.getDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("%1$s, Android API %2$s, revision %3$s%4$s", this.getDisplayName(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = String.format("%1$s, Android API %2$s, revision %3$s%4$s\nBy %5$s", this.getDisplayName(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "", this.getDisplayVendor());
        String d = this.getDescription();
        if (d != null && d.length() > 0) {
            s = s + '\n' + d;
        }
        s = s + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File addons = new File(osSdkRoot, "add-ons");
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (target.isPlatform() || !target.getVersion().equals(this.mVersion) || (!target.getName().equals(this.getNameId()) || !target.getVendor().equals(this.getVendorId())) && (!target.getName().equals(this.getDisplayName()) || !target.getVendor().equals(this.getDisplayVendor()))) continue;
            return new File(target.getLocation());
        }
        String name = this.encodeAddonName();
        for (int i = 0; i < 100; ++i) {
            String name2 = i == 0 ? name : String.format("%s-%d", name, i);
            File folder = new File(addons, name2);
            if (folder.exists()) continue;
            return folder;
        }
        return null;
    }

    private String encodeAddonName() {
        String name = String.format("addon-%s-%s-%s", this.getNameId(), this.getVendorId(), this.mVersion.getApiString());
        name = name.toLowerCase(Locale.US);
        name = name.replaceAll("[^a-z0-9_-]+", "_");
        name = name.replaceAll("_+", "_");
        return name;
    }

    private String sanitizeDisplayToNameId(String displayName) {
        String name = displayName.toLowerCase(Locale.US);
        name = name.replaceAll("[^a-z0-9_-]+", "_");
        if ((name = name.replaceAll("_+", "_")).length() > 1) {
            name = name.replaceAll("^_+", "");
        }
        if (name.length() > 1) {
            name = name.replaceAll("_+$", "");
        }
        return name;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof AddonPackage) {
            AddonPackage newPkg = (AddonPackage)pkg;
            if (this.getNameId().equals(newPkg.getNameId()) && this.getAndroidVersion().equals(newPkg.getAndroidVersion())) {
                if (this.getVendorId().equals(newPkg.getVendorId())) {
                    return true;
                }
                return this.getDisplayVendor().equals(newPkg.getDisplayVendor());
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result = 31 * result + Arrays.hashCode(this.mLibs);
        result = 31 * result + (this.mDisplayName == null ? 0 : this.mDisplayName.hashCode());
        result = 31 * result + (this.mVendorDisplay == null ? 0 : this.mVendorDisplay.hashCode());
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AddonPackage)) {
            return false;
        }
        AddonPackage other = (AddonPackage)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        if (!Arrays.equals(this.mLibs, other.mLibs)) {
            return false;
        }
        if (this.mNameId == null ? other.mNameId != null : !this.mNameId.equals(other.mNameId)) {
            return false;
        }
        if (this.mVendorId == null ? other.mVendorId != null : !this.mVendorId.equals(other.mVendorId)) {
            return false;
        }
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        int pos = s.indexOf("|r:");
        assert (pos > 0);
        s = s.substring(0, pos) + "|vid:" + this.getVendorId() + "|nid:" + this.getNameId() + s.substring(pos);
        return s;
    }

    public static class Lib {
        private final String mName;
        private final String mDescription;

        public Lib(String name, String description) {
            this.mName = name;
            this.mDescription = description;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
            result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Lib)) {
                return false;
            }
            Lib other = (Lib)obj;
            if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
                return false;
            }
            return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
        }
    }
}

