/*
 * Decompiled with CFR 0.152.
 */
package com.android.jobb;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF {
    public static final int SALT_LEN = 8;
    private static final int ROUNDS = 1024;
    private static final int KEY_BITS = 128;

    public static byte[] getKey(String password, byte[] saltBytes) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        PBEKeySpec pwKey = new PBEKeySpec(password.toCharArray(), saltBytes, 1024, 128);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        try {
            PBEKey pbeKey = (PBEKey)factory.generateSecret(pwKey);
            byte[] pbkdfKey = pbeKey.getEncoded();
            return pbkdfKey;
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getRandomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] saltBytes = new byte[8];
        random.nextBytes(saltBytes);
        return saltBytes;
    }
}

