/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public interface IProperties {
    public String getProperty(String var1);

    public String getProperty(String var1, String var2);

    public boolean isOverridden(String var1);

    public IProperties copy();

    public Iterator properties();

    public Properties toProperties();

    public String[] toAppArgsForm(String var1);

    public boolean isEmpty();

    public void list(PrintStream var1);

    public void list(PrintWriter var1);

    public String setProperty(String var1, String var2);

    public static abstract class Factory {
        public static IProperties create(IMapper iMapper) {
            return new PropertiesImpl(null, iMapper);
        }

        public static IProperties wrap(Properties properties, IMapper iMapper) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                hashMap.put(string, string2);
            }
            return new PropertiesImpl(hashMap, iMapper);
        }

        public static IProperties combine(IProperties iProperties, IProperties iProperties2) {
            IProperties iProperties3 = iProperties != null ? iProperties.copy() : Factory.create(null);
            ((PropertiesImpl)iProperties3).getLastProperties().setDelegate((PropertiesImpl)iProperties2);
            return iProperties3;
        }

        private static final class PropertiesImpl
        implements IProperties,
        Cloneable {
            private final IMapper m_mapper;
            private HashMap m_valueMap;
            private PropertiesImpl m_delegate;
            private transient Set m_unmappedKeySet;

            public String getProperty(String string) {
                return this.getProperty(string, null);
            }

            public String getProperty(String string, String string2) {
                String string3;
                String string4 = (String)this.m_valueMap.get(string);
                if (string4 == null && this.m_mapper != null && (string3 = this.m_mapper.getMappedKey(string)) != null) {
                    string4 = (String)this.m_valueMap.get(string3);
                }
                if (string4 == null && this.m_delegate != null) {
                    string4 = this.m_delegate.getProperty(string, null);
                }
                return string4 != null ? string4 : string2;
            }

            public boolean isOverridden(String string) {
                return this.m_valueMap.containsKey(string);
            }

            public IProperties copy() {
                PropertiesImpl propertiesImpl;
                try {
                    propertiesImpl = (PropertiesImpl)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Error(cloneNotSupportedException.toString());
                }
                propertiesImpl.m_valueMap = (HashMap)this.m_valueMap.clone();
                propertiesImpl.m_unmappedKeySet = null;
                PropertiesImpl propertiesImpl2 = propertiesImpl;
                PropertiesImpl propertiesImpl3 = this.m_delegate;
                while (propertiesImpl3 != null) {
                    PropertiesImpl propertiesImpl4;
                    try {
                        propertiesImpl4 = (PropertiesImpl)propertiesImpl3.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new Error(cloneNotSupportedException.toString());
                    }
                    propertiesImpl4.m_valueMap = (HashMap)propertiesImpl3.m_valueMap.clone();
                    propertiesImpl4.m_unmappedKeySet = null;
                    propertiesImpl2.setDelegate(propertiesImpl4);
                    propertiesImpl2 = propertiesImpl4;
                    propertiesImpl3 = propertiesImpl3.m_delegate;
                }
                return propertiesImpl;
            }

            public Iterator properties() {
                return this.unmappedKeySet().iterator();
            }

            public Properties toProperties() {
                Properties properties = new Properties();
                Iterator iterator = this.properties();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = this.getProperty(string);
                    properties.setProperty(string, string2);
                }
                return properties;
            }

            public boolean isEmpty() {
                return this.m_valueMap.isEmpty() && (this.m_delegate == null || this.m_delegate != null && this.m_delegate.isEmpty());
            }

            public String[] toAppArgsForm(String string) {
                if (this.isEmpty()) {
                    return IConstants.EMPTY_STRING_ARRAY;
                }
                if (string == null) {
                    throw new IllegalArgumentException("null input: prefix");
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                String[] stringArray = this.properties();
                while (stringArray.hasNext()) {
                    String string2 = (String)stringArray.next();
                    String string3 = this.getProperty(string2, "");
                    arrayList.add(string.concat(string2).concat("=").concat(string3));
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }

            public void list(PrintStream printStream) {
                if (printStream != null) {
                    Iterator iterator = this.properties();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = this.getProperty(string);
                        printStream.println(string + ":\t[" + string2 + "]");
                    }
                }
            }

            public void list(PrintWriter printWriter) {
                if (printWriter != null) {
                    Iterator iterator = this.properties();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = this.getProperty(string);
                        printWriter.println(string + ":\t[" + string2 + "]");
                    }
                }
            }

            public String setProperty(String string, String string2) {
                if (string2 == null) {
                    throw new IllegalArgumentException("null input: value");
                }
                this.m_unmappedKeySet = null;
                return this.m_valueMap.put(string, string2);
            }

            PropertiesImpl(HashMap hashMap, IMapper iMapper) {
                this.m_mapper = iMapper;
                this.m_valueMap = hashMap != null ? hashMap : new HashMap();
                this.m_delegate = null;
            }

            Set unmappedKeySet() {
                TreeSet treeSet = this.m_unmappedKeySet;
                if (treeSet == null) {
                    treeSet = new TreeSet();
                    treeSet.addAll(this.m_valueMap.keySet());
                    if (this.m_delegate != null) {
                        treeSet.addAll(this.m_delegate.unmappedKeySet());
                    }
                    this.m_unmappedKeySet = treeSet;
                    return treeSet;
                }
                return treeSet;
            }

            PropertiesImpl getLastProperties() {
                PropertiesImpl propertiesImpl = this;
                PropertiesImpl propertiesImpl2 = this.m_delegate;
                while (propertiesImpl2 != null) {
                    if (propertiesImpl2 == this) {
                        throw new IllegalStateException("cyclic delegation detected");
                    }
                    propertiesImpl = propertiesImpl2;
                    propertiesImpl2 = propertiesImpl2.m_delegate;
                }
                return propertiesImpl;
            }

            void setDelegate(PropertiesImpl propertiesImpl) {
                this.m_delegate = propertiesImpl;
                this.m_unmappedKeySet = null;
            }
        }
    }

    public static interface IMapper {
        public String getMappedKey(String var1);
    }
}

