/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class Files {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readFileList(File file) throws IOException {
        String[] stringArray;
        if (file == null) {
            throw new IllegalArgumentException("null input: atfile");
        }
        LinkedList<String[]> linkedList = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file), 8192);
            linkedList = new LinkedList<String[]>();
            while ((stringArray = bufferedReader.readLine()) != null) {
                if ((stringArray = stringArray.trim()).length() == 0 || stringArray.charAt(0) == '#') continue;
                linkedList.add(stringArray);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (linkedList == null || linkedList.isEmpty()) {
            return IConstants.EMPTY_STRING_ARRAY;
        }
        stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    public static File[] pathToFiles(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("null input: path");
        }
        if (stringArray.length == 0) {
            return IConstants.EMPTY_FILE_ARRAY;
        }
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        String string = ",".concat(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) {
                throw new IllegalArgumentException("null input: path[" + i + "]");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (bl) {
                    string3 = Files.canonicalizePathname(string3);
                }
                if (!hashSet.add(string3)) continue;
                arrayList.add(new File(string3));
            }
        }
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    public static String canonicalizePathname(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null input: pathname");
        }
        try {
            return new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            return new File(string).getAbsolutePath();
        }
    }

    public static File canonicalizeFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception exception) {
            return file.getAbsoluteFile();
        }
    }

    public static String getFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(n);
    }

    public static File newFile(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (file == null || file2.isAbsolute()) {
            return file2;
        }
        return new File(file, file2.getPath());
    }

    public static File newFile(File file, String string) {
        if (string == null) {
            throw new IllegalArgumentException("null input: file");
        }
        File file2 = new File(string);
        if (file == null || file2.isAbsolute()) {
            return file2;
        }
        return new File(file, string);
    }

    public static File newFile(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("null input: file");
        }
        File file = new File(string2);
        if (string == null || file.isAbsolute()) {
            return file;
        }
        return new File(string, string2);
    }

    public static boolean renameFile(File file, File file2, boolean bl) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("invalid input source: [" + file + "]");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("null input: target");
        }
        boolean bl2 = file2.exists();
        if (!bl2 || bl) {
            if (bl2) {
                file2.delete();
            } else {
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.equals(file.getParentFile())) {
                    file3.mkdirs();
                }
            }
            return file.renameTo(file2);
        }
        return false;
    }

    public static File createTempFile(File file, String string, String string2) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("invalid parent directory: [" + file + "]");
        }
        if (string == null || string.length() < 3) {
            throw new IllegalArgumentException("null or less than 3 chars long: " + string);
        }
        if (string2 == null) {
            string2 = ".tmp";
        } else if (string2.charAt(0) != '.') {
            string2 = ".".concat(string2);
        }
        return File.createTempFile(string, string2, file);
    }

    private Files() {
    }
}

