/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.LineNumber_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class LineNumberTableAttribute_info
extends Attribute_info {
    private List m_lines;

    public LineNumber_info get(int n) {
        return (LineNumber_info)this.m_lines.get(n);
    }

    public int size() {
        return this.m_lines.size();
    }

    public long length() {
        return 8 + (this.m_lines.size() << 2);
    }

    public void accept(IAttributeVisitor iAttributeVisitor, Object object) {
        iAttributeVisitor.visit(this, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LineNumberTableAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.length() + "]\n");
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append("            " + this.get(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        LineNumberTableAttribute_info lineNumberTableAttribute_info = (LineNumberTableAttribute_info)super.clone();
        int n = this.m_lines.size();
        lineNumberTableAttribute_info.m_lines = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            lineNumberTableAttribute_info.m_lines.add(((LineNumber_info)this.m_lines.get(i)).clone());
        }
        return lineNumberTableAttribute_info;
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        super.writeInClassFormat(uDataOutputStream);
        int n = this.m_lines.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            ((LineNumber_info)this.m_lines.get(i)).writeInClassFormat(uDataOutputStream);
        }
    }

    LineNumberTableAttribute_info(int n, long l, UDataInputStream uDataInputStream) throws IOException {
        super(n, l);
        int n2 = uDataInputStream.readU2();
        this.m_lines = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.m_lines.add(new LineNumber_info(uDataInputStream));
        }
    }
}

